/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Namespace;
import org.joyqueue.nsr.journalkeeper.domain.NamespaceDTO;

public class NamespaceConverter {
    public static NamespaceDTO convert(Namespace namespace) {
        if (namespace == null) {
            return null;
        }
        NamespaceDTO namespaceDTO = new NamespaceDTO();
        namespaceDTO.setId(namespace.getCode());
        namespaceDTO.setCode(namespace.getCode());
        namespaceDTO.setName(namespace.getName());
        return namespaceDTO;
    }

    public static Namespace convert(NamespaceDTO namespaceDTO) {
        if (namespaceDTO == null) {
            return null;
        }
        Namespace namespace = new Namespace();
        namespace.setCode(namespaceDTO.getCode());
        namespace.setName(namespaceDTO.getName());
        return namespace;
    }

    public static List<Namespace> convert(List<NamespaceDTO> namespaceDTOList) {
        if (CollectionUtils.isEmpty(namespaceDTOList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)namespaceDTOList.size());
        for (NamespaceDTO namespaceDTO : namespaceDTOList) {
            result.add(NamespaceConverter.convert(namespaceDTO));
        }
        return result;
    }
}

