/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.journalkeeper.domain.PartitionGroupDTO;
import org.joyqueue.nsr.journalkeeper.helper.ArrayHelper;

public class PartitionGroupConverter {
    public static PartitionGroupDTO convert(PartitionGroup partitionGroup) {
        if (partitionGroup == null) {
            return null;
        }
        PartitionGroupDTO partitionGroupDTO = new PartitionGroupDTO();
        partitionGroupDTO.setId(PartitionGroupConverter.generateId(partitionGroup));
        partitionGroupDTO.setTopic(partitionGroup.getTopic().getCode());
        partitionGroupDTO.setNamespace(partitionGroup.getTopic().getNamespace());
        partitionGroupDTO.setGroup(partitionGroup.getGroup());
        partitionGroupDTO.setPartitions(ArrayHelper.toString(partitionGroup.getPartitions()));
        partitionGroupDTO.setLeader(partitionGroup.getLeader());
        partitionGroupDTO.setRecLeader(partitionGroup.getRecLeader());
        partitionGroupDTO.setTerm(partitionGroup.getTerm());
        partitionGroupDTO.setReplicas(ArrayHelper.toString(partitionGroup.getReplicas()));
        partitionGroupDTO.setIsrs(ArrayHelper.toString(partitionGroup.getIsrs()));
        partitionGroupDTO.setLearners(ArrayHelper.toString(partitionGroup.getLearners()));
        partitionGroupDTO.setOutSyncReplicas(ArrayHelper.toString(partitionGroup.getOutSyncReplicas()));
        partitionGroupDTO.setElectType((byte)partitionGroup.getElectType().type());
        return partitionGroupDTO;
    }

    protected static String generateId(PartitionGroup partitionGroup) {
        return String.format("%s.%s", partitionGroup.getTopic().getFullName(), partitionGroup.getGroup());
    }

    public static PartitionGroup convert(PartitionGroupDTO partitionGroupDTO) {
        if (partitionGroupDTO == null) {
            return null;
        }
        PartitionGroup partitionGroup = new PartitionGroup();
        partitionGroup.setTopic(TopicName.parse((String)partitionGroupDTO.getTopic(), (String)partitionGroupDTO.getNamespace()));
        partitionGroup.setGroup(partitionGroupDTO.getGroup().intValue());
        partitionGroup.setPartitions(ArrayHelper.toShortSet(partitionGroupDTO.getPartitions()));
        partitionGroup.setLeader(partitionGroupDTO.getLeader());
        partitionGroup.setRecLeader(partitionGroupDTO.getRecLeader());
        partitionGroup.setTerm(partitionGroupDTO.getTerm());
        partitionGroup.setReplicas(ArrayHelper.toIntSet(partitionGroupDTO.getReplicas()));
        partitionGroup.setIsrs(ArrayHelper.toIntSet(partitionGroupDTO.getIsrs()));
        partitionGroup.setLearners(ArrayHelper.toIntSet(partitionGroupDTO.getLearners()));
        partitionGroup.setOutSyncReplicas(ArrayHelper.toIntList(partitionGroupDTO.getOutSyncReplicas()));
        partitionGroup.setElectType(PartitionGroup.ElectType.valueOf((int)partitionGroupDTO.getElectType().byteValue()));
        return partitionGroup;
    }

    public static List<PartitionGroup> convert(List<PartitionGroupDTO> partitionGroupDTOList) {
        if (CollectionUtils.isEmpty(partitionGroupDTOList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)partitionGroupDTOList.size());
        for (PartitionGroupDTO partitionGroupDTO : partitionGroupDTOList) {
            result.add(PartitionGroupConverter.convert(partitionGroupDTO));
        }
        return result;
    }
}

