/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.journalkeeper.domain.PartitionGroupReplicaDTO;

public class PartitionGroupReplicaConverter {
    public static String generateId(Replica replica) {
        return PartitionGroupReplicaConverter.generateId(replica.getTopic().getFullName(), replica.getGroup(), replica.getBrokerId());
    }

    public static String generateId(String topic, int group, int replica) {
        return String.format("%s.%s.%s", topic, group, replica);
    }

    public static PartitionGroupReplicaDTO convert(Replica replica) {
        if (replica == null) {
            return null;
        }
        PartitionGroupReplicaDTO partitionGroupReplicaDTO = new PartitionGroupReplicaDTO();
        partitionGroupReplicaDTO.setId(PartitionGroupReplicaConverter.generateId(replica));
        partitionGroupReplicaDTO.setTopic(replica.getTopic().getCode());
        partitionGroupReplicaDTO.setNamespace(replica.getTopic().getNamespace());
        partitionGroupReplicaDTO.setGroup(replica.getGroup());
        partitionGroupReplicaDTO.setBrokerId(Long.valueOf(replica.getBrokerId()));
        return partitionGroupReplicaDTO;
    }

    public static Replica convert(PartitionGroupReplicaDTO partitionGroupReplicaDTO) {
        if (partitionGroupReplicaDTO == null) {
            return null;
        }
        Replica replica = new Replica();
        replica.setId(partitionGroupReplicaDTO.getId());
        replica.setTopic(TopicName.parse((String)partitionGroupReplicaDTO.getTopic(), (String)partitionGroupReplicaDTO.getNamespace()));
        replica.setBrokerId(Integer.valueOf(String.valueOf(partitionGroupReplicaDTO.getBrokerId())).intValue());
        replica.setGroup(partitionGroupReplicaDTO.getGroup().intValue());
        return replica;
    }

    public static List<Replica> convert(List<PartitionGroupReplicaDTO> partitionGroupReplicaDTOS) {
        if (CollectionUtils.isEmpty(partitionGroupReplicaDTOS)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)partitionGroupReplicaDTOS.size());
        for (PartitionGroupReplicaDTO partitionGroupReplicaDTO : partitionGroupReplicaDTOS) {
            result.add(PartitionGroupReplicaConverter.convert(partitionGroupReplicaDTO));
        }
        return result;
    }
}

