/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.journalkeeper.domain.ProducerDTO;
import org.joyqueue.nsr.journalkeeper.helper.JsonHelper;

public class ProducerConverter {
    public static ProducerDTO convert(Producer producer) {
        if (producer == null) {
            return null;
        }
        ProducerDTO producerDTO = new ProducerDTO();
        producerDTO.setId(ProducerConverter.generateId(producer));
        producerDTO.setClientType(producer.getClientType().value());
        producerDTO.setProducePolicy(JsonHelper.toJson(producer.getProducerPolicy()));
        producerDTO.setLimitPolicy(JsonHelper.toJson(producer.getLimitPolicy()));
        producerDTO.setTopic(producer.getTopic().getCode());
        producerDTO.setNamespace(producer.getTopic().getNamespace());
        producerDTO.setApp(producer.getApp());
        return producerDTO;
    }

    protected static String generateId(Producer producer) {
        return String.format("%s.%s", producer.getTopic().getFullName(), producer.getApp());
    }

    public static Producer convert(ProducerDTO producerDTO) {
        if (producerDTO == null) {
            return null;
        }
        Producer producer = new Producer();
        producer.setTopic(TopicName.parse((String)producerDTO.getTopic(), (String)producerDTO.getNamespace()));
        producer.setApp(producerDTO.getApp());
        producer.setClientType(ClientType.valueOf((int)producerDTO.getClientType().byteValue()));
        producer.setProducerPolicy(JsonHelper.parseJson(Producer.ProducerPolicy.class, producerDTO.getProducePolicy()));
        producer.setLimitPolicy(JsonHelper.parseJson(Producer.ProducerLimitPolicy.class, producerDTO.getLimitPolicy()));
        return producer;
    }

    public static List<Producer> convert(List<ProducerDTO> producerDTOList) {
        if (CollectionUtils.isEmpty(producerDTOList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)producerDTOList.size());
        for (ProducerDTO producerDTO : producerDTOList) {
            result.add(ProducerConverter.convert(producerDTO));
        }
        return result;
    }
}

