/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.journalkeeper.domain.TopicDTO;
import org.joyqueue.nsr.journalkeeper.helper.ArrayHelper;

public class TopicConverter {
    public static TopicDTO convert(Topic topic) {
        if (topic == null) {
            return null;
        }
        TopicDTO topicDTO = new TopicDTO();
        topicDTO.setId(topic.getName().getFullName());
        topicDTO.setCode(topic.getName().getCode());
        topicDTO.setNamespace(topic.getName().getNamespace());
        topicDTO.setPartitions(topic.getPartitions());
        topicDTO.setType(topic.getType().code());
        topicDTO.setPriorityPartitions(ArrayHelper.toString(topic.getPriorityPartitions()));
        return topicDTO;
    }

    public static Topic convert(TopicDTO topicDTO) {
        if (topicDTO == null) {
            return null;
        }
        Topic topic = new Topic();
        topic.setName(TopicName.parse((String)topicDTO.getCode(), (String)topicDTO.getNamespace()));
        topic.setPartitions(topicDTO.getPartitions().shortValue());
        topic.setType(Topic.Type.valueOf((byte)topicDTO.getType()));
        topic.setPriorityPartitions(ArrayHelper.toShortSet(topicDTO.getPriorityPartitions()));
        return topic;
    }

    public static List<Topic> convert(List<TopicDTO> topicDTOList) {
        if (CollectionUtils.isEmpty(topicDTOList)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)topicDTOList.size());
        for (TopicDTO topicDTO : topicDTOList) {
            result.add(TopicConverter.convert(topicDTO));
        }
        return result;
    }
}

