/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ArrayHelper {
    private static final String DEFAULT_SPLITTER = ",";

    public static List<Integer> toIntList(String value) {
        return ArrayHelper.toIntList(value, DEFAULT_SPLITTER);
    }

    public static List<Integer> toIntList(String value, String splitter) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyList();
        }
        Object[] splitValue = value.split(splitter);
        if (ArrayUtils.isEmpty((Object[])splitValue)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (Object item : splitValue) {
            result.add(Integer.valueOf((String)item));
        }
        return result;
    }

    public static Set<Integer> toIntSet(String value) {
        return ArrayHelper.toIntSet(value, DEFAULT_SPLITTER);
    }

    public static Set<Integer> toIntSet(String value, String splitter) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptySet();
        }
        Object[] splitValue = value.split(splitter);
        if (ArrayUtils.isEmpty((Object[])splitValue)) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (Object item : splitValue) {
            result.add(Integer.valueOf((String)item));
        }
        return result;
    }

    public static Set<Short> toShortSet(String value) {
        return ArrayHelper.toShortSet(value, DEFAULT_SPLITTER);
    }

    public static Set<Short> toShortSet(String value, String splitter) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptySet();
        }
        Object[] splitValue = value.split(splitter);
        if (ArrayUtils.isEmpty((Object[])splitValue)) {
            return Collections.emptySet();
        }
        HashSet result = Sets.newHashSet();
        for (Object item : splitValue) {
            result.add(Short.valueOf((String)item));
        }
        return result;
    }

    public static String toString(Collection collection) {
        return ArrayHelper.toString(collection, DEFAULT_SPLITTER);
    }

    public static String toString(Collection collection, String splitter) {
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Object item : collection) {
            result.append(String.valueOf(item));
            result.append(splitter);
        }
        return result.substring(0, result.length() - 1);
    }
}

