/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.journalkeeper.sql.client.domain.ResultSet;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.nsr.journalkeeper.helper.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetHelper.class);
    private static final ConcurrentMap<Class<?>, List<FieldEntry>> fieldCache = Maps.newConcurrentMap();

    public static <T> T assembleOnce(Class<T> type, ResultSet resultSet) {
        List rows = resultSet.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return null;
        }
        return ResultSetHelper.doAssemble(type, (Map)rows.get(0));
    }

    public static <T> List<T> assembleList(Class<T> type, ResultSet resultSet) {
        List rows = resultSet.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)rows.size());
        for (Map row : rows) {
            result.add(ResultSetHelper.doAssemble(type, row));
        }
        return result;
    }

    protected static <T> T doAssemble(Class<T> type, Map<String, String> row) {
        try {
            List<FieldEntry> fields = ResultSetHelper.getFields(type);
            T result = type.newInstance();
            for (FieldEntry entry : fields) {
                String value = row.get(entry.getAlias());
                if (value == null) continue;
                try {
                    Object convertedValue = ResultSetHelper.convertValue(entry.getType(), value);
                    entry.getField().setAccessible(true);
                    entry.getField().set(result, convertedValue);
                }
                catch (Exception e) {
                    logger.error("doAssemble exception, field: {}, type: {}, columns: {}", new Object[]{entry.getName(), type, row, e});
                }
            }
            return result;
        }
        catch (Exception e) {
            logger.error("doAssemble exception, type: {}, columns: {}", new Object[]{type, row, e});
            return null;
        }
    }

    protected static <T> T convertValue(Class<T> type, String value) throws Exception {
        if (type.equals(String.class)) {
            return (T)value;
        }
        if (type.equals(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (type.equals(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (type.equals(Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (type.equals(Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (type.equals(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (type.equals(Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (type.equals(Double.class)) {
            return (T)Double.valueOf(value);
        }
        if (type.equals(Date.class)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                return (T)format.parse(value);
            }
            catch (Exception e) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return (T)format.parse(value);
            }
        }
        throw new UnsupportedOperationException(type.getName());
    }

    protected static List<FieldEntry> getFields(Class<?> type) {
        List fields = (List)fieldCache.get(type);
        if (fields != null) {
            return fields;
        }
        fields = Lists.newArrayList();
        for (Field field : type.getDeclaredFields()) {
            Column column = field.getAnnotation(Column.class);
            FieldEntry entry = new FieldEntry();
            entry.setName(field.getName().toUpperCase());
            entry.setAlias(field.getName().toUpperCase());
            entry.setType(field.getType());
            entry.setField(field);
            if (column != null) {
                entry.setAlias(column.alias().toUpperCase());
            }
            fields.add(entry);
        }
        fieldCache.put(type, fields);
        return fields;
    }

    private static class FieldEntry {
        private String name;
        private String alias;
        private Class<?> type;
        private Field field;

        private FieldEntry() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }
    }
}

