/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.text.SimpleDateFormat;
import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.AppTokenDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class AppTokenRepository {
    private static final String TABLE = "app_token";
    private static final String COLUMNS = "id, app, token, effective_time, expiration_time";
    private static final String UPDATE_COLUMNS = "app = ?, token = ?, effective_time = ?, expiration_time = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, app, token, effective_time, expiration_time", "app_token");
    private static final String GET_BY_APP_AND_CODE = String.format("SELECT %s FROM %s WHERE app = ? AND token = ?", "id, app, token, effective_time, expiration_time", "app_token");
    private static final String GET_BY_APP = String.format("SELECT %s FROM %s WHERE app = ?", "id, app, token, effective_time, expiration_time", "app_token");
    private static final String GET_ALL = String.format("SELECT %s FROM %s", "id, app, token, effective_time, expiration_time", "app_token");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?)", "app_token", "id, app, token, effective_time, expiration_time");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "app_token", "app = ?, token = ?, effective_time = ?, expiration_time = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "app_token");
    private BaseRepository baseRepository;

    public AppTokenRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public AppTokenDTO getById(long id) {
        return this.baseRepository.queryOnce(AppTokenDTO.class, GET_BY_ID, id);
    }

    public AppTokenDTO getByAppAndToken(String app, String token) {
        return this.baseRepository.queryOnce(AppTokenDTO.class, GET_BY_APP_AND_CODE, app, token);
    }

    public List<AppTokenDTO> getByApp(String app) {
        return this.baseRepository.query(AppTokenDTO.class, GET_BY_APP, app);
    }

    public List<AppTokenDTO> getAll() {
        return this.baseRepository.query(AppTokenDTO.class, GET_ALL, new Object[0]);
    }

    public AppTokenDTO add(AppTokenDTO appTokenDTO) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.baseRepository.insert(ADD, appTokenDTO.getId(), appTokenDTO.getApp(), appTokenDTO.getToken(), format.format(appTokenDTO.getEffectiveTime()), format.format(appTokenDTO.getExpirationTime()));
        return appTokenDTO;
    }

    public AppTokenDTO update(AppTokenDTO appTokenDTO) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.baseRepository.update(UPDATE_BY_ID, appTokenDTO.getApp(), appTokenDTO.getToken(), format.format(appTokenDTO.getEffectiveTime()), format.format(appTokenDTO.getExpirationTime()), appTokenDTO.getId());
        return appTokenDTO;
    }

    public int deleteById(long id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

