/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import io.journalkeeper.sql.client.BatchSQLOperator;
import io.journalkeeper.sql.client.SQLOperator;
import io.journalkeeper.sql.client.domain.ResultSet;
import java.util.List;
import java.util.Map;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.monitor.TraceStat;
import org.joyqueue.nsr.journalkeeper.BatchOperationContext;
import org.joyqueue.nsr.journalkeeper.helper.ResultSetHelper;

public class BaseRepository {
    private SQLOperator sqlOperator;
    private PointTracer tracer;

    public BaseRepository(SQLOperator sqlOperator, PointTracer tracer) {
        this.sqlOperator = sqlOperator;
        this.tracer = tracer;
    }

    public String insert(String sql, Object ... params) {
        TraceStat trace = this.tracer.begin(this.getTraceKey(sql));
        try {
            String result = this.doInsert(sql, params);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    protected String doInsert(String sql, Object ... params) {
        BatchSQLOperator batchSQLOperator = BatchOperationContext.getBatchSQLOperator();
        if (batchSQLOperator != null) {
            batchSQLOperator.insert(sql, params);
            return null;
        }
        Object result = this.sqlOperator.insert(sql, params);
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public int update(String sql, Object ... params) {
        TraceStat trace = this.tracer.begin(this.getTraceKey(sql));
        try {
            int result = this.doUpdate(sql, params);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    protected int doUpdate(String sql, Object ... params) {
        BatchSQLOperator batchSQLOperator = BatchOperationContext.getBatchSQLOperator();
        if (batchSQLOperator != null) {
            batchSQLOperator.update(sql, params);
            return 0;
        }
        return this.sqlOperator.update(sql, params);
    }

    public int delete(String sql, Object ... params) {
        TraceStat trace = this.tracer.begin(this.getTraceKey(sql));
        try {
            int result = this.doDelete(sql, params);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    protected int doDelete(String sql, Object ... params) {
        BatchSQLOperator batchSQLOperator = BatchOperationContext.getBatchSQLOperator();
        if (batchSQLOperator != null) {
            batchSQLOperator.delete(sql, params);
            return 0;
        }
        return this.sqlOperator.delete(sql, params);
    }

    public ResultSet query(String sql, Object ... params) {
        TraceStat trace = this.tracer.begin(this.getTraceKey(sql));
        try {
            ResultSet result = this.doQuery(sql, params);
            this.tracer.end(trace);
            return result;
        }
        catch (Exception e) {
            this.tracer.error(trace);
            throw e;
        }
    }

    protected ResultSet doQuery(String sql, Object ... params) {
        return this.sqlOperator.query(sql, params);
    }

    public int count(String sql, Object ... params) {
        ResultSet resultSet = this.query(sql, params);
        return Integer.valueOf((String)((Map)resultSet.getRows().get(0)).entrySet().iterator().next().getValue());
    }

    public <T> List<T> query(Class<T> type, String sql, List params) {
        Object[] array = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            array[i] = params.get(i);
        }
        return this.query(type, sql, array);
    }

    public <T> T queryOnce(Class<T> type, String sql, List params) {
        Object[] array = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            array[i] = params.get(i);
        }
        return this.queryOnce(type, sql, array);
    }

    public <T> List<T> query(Class<T> type, String sql, Object ... params) {
        ResultSet resultSet = this.query(sql, params);
        return ResultSetHelper.assembleList(type, resultSet);
    }

    public <T> T queryOnce(Class<T> type, String sql, Object ... params) {
        ResultSet resultSet = this.query(sql, params);
        return ResultSetHelper.assembleOnce(type, resultSet);
    }

    protected String getTraceKey(String name) {
        return "NameService.journalkeeper." + name.replace(" = ?", "_").replace(" ", "_").replace("`", "").replace(",", "");
    }
}

