/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.nsr.journalkeeper.domain.BrokerDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;
import org.joyqueue.nsr.model.BrokerQuery;

public class BrokerRepository {
    private static final String TABLE = "broker";
    private static final String COLUMNS = "id, ip, port, data_center, retry_type, permission";
    private static final String UPDATE_COLUMNS = "ip = ?, port = ?, data_center = ?, retry_type = ?, permission = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, ip, port, data_center, retry_type, permission", "broker");
    private static final String GET_BY_IP_AND_PORT = String.format("SELECT %s FROM %s WHERE ip = ? AND port = ? ORDER BY ip", "id, ip, port, data_center, retry_type, permission", "broker");
    private static final String GET_BY_RETRY_TYPE = String.format("SELECT %s FROM %s WHERE retry_type = ? ORDER BY ip", "id, ip, port, data_center, retry_type, permission", "broker");
    private static final String GET_BY_IDS = String.format("SELECT %s FROM %s WHERE id in ", "id, ip, port, data_center, retry_type, permission", "broker");
    private static final String GET_ALL = String.format("SELECT %s FROM %s ORDER BY ip", "id, ip, port, data_center, retry_type, permission", "broker");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?,?)", "broker", "id, ip, port, data_center, retry_type, permission");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "broker", "ip = ?, port = ?, data_center = ?, retry_type = ?, permission = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "broker");
    private BaseRepository baseRepository;

    public BrokerRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public BrokerDTO getById(long id) {
        return this.baseRepository.queryOnce(BrokerDTO.class, GET_BY_ID, id);
    }

    public BrokerDTO getByIpAndPort(String ip, int port) {
        return this.baseRepository.queryOnce(BrokerDTO.class, GET_BY_IP_AND_PORT, ip, port);
    }

    public List<BrokerDTO> getByRetryType(String retryType) {
        return this.baseRepository.query(BrokerDTO.class, GET_BY_RETRY_TYPE, retryType);
    }

    public List<BrokerDTO> getByIds(List ids) {
        StringBuilder idsSql = new StringBuilder();
        idsSql.append("(");
        for (int i = 0; i < ids.size(); ++i) {
            idsSql.append("?");
            if (i == ids.size() - 1) continue;
            idsSql.append(",");
        }
        idsSql.append(")");
        return this.baseRepository.query(BrokerDTO.class, GET_BY_IDS + idsSql.toString(), ids);
    }

    public List<BrokerDTO> getAll() {
        return this.baseRepository.query(BrokerDTO.class, GET_ALL, new Object[0]);
    }

    public int getSearchCount(BrokerQuery query) {
        LinkedList<Object> params = new LinkedList<Object>();
        String sql = this.getSearchSql(String.format("SELECT COUNT(*) FROM %s WHERE 1 = 1", TABLE), query, params);
        return this.baseRepository.count(sql, params.toArray(new Object[0]));
    }

    public List<BrokerDTO> search(QPageQuery<BrokerQuery> pageQuery) {
        Pagination pagination = pageQuery.getPagination();
        LinkedList<Object> params = new LinkedList<Object>();
        StringBuilder sql = new StringBuilder(this.getSearchSql(String.format("SELECT %s FROM %s WHERE 1 = 1", COLUMNS, TABLE), (BrokerQuery)pageQuery.getQuery(), params));
        if (pagination != null) {
            sql.append(String.format(" LIMIT %s, %s", (pagination.getPage() - 1) * pagination.getSize(), pagination.getSize()));
        }
        return this.baseRepository.query(BrokerDTO.class, sql.toString(), params.toArray(new Object[0]));
    }

    protected String getSearchSql(String prefix, BrokerQuery query, List<Object> params) {
        StringBuilder sql = new StringBuilder(prefix);
        if (StringUtils.isNotBlank((CharSequence)query.getIp())) {
            sql.append(" AND ip = ?");
            params.add(query.getIp());
        }
        if (query.getPort() > 0) {
            sql.append(" AND port = ?");
            params.add(query.getPort());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getRetryType())) {
            sql.append(" AND retry_type = ?");
            params.add(query.getRetryType());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getKeyword())) {
            if (StringUtils.isNumeric((CharSequence)query.getKeyword())) {
                sql.append(" AND (id = ? OR ip LIKE ?)");
                params.add(query.getKeyword());
                params.add("%" + query.getKeyword() + "%");
            } else {
                sql.append(" AND ip LIKE ?");
                params.add("%" + query.getKeyword() + "%");
            }
        }
        return sql.toString();
    }

    public BrokerDTO add(BrokerDTO brokerDTO) {
        this.baseRepository.insert(ADD, brokerDTO.getId(), brokerDTO.getIp(), brokerDTO.getPort(), brokerDTO.getDataCenter(), brokerDTO.getRetryType(), brokerDTO.getPermission());
        return brokerDTO;
    }

    public BrokerDTO update(BrokerDTO brokerDTO) {
        this.baseRepository.update(UPDATE_BY_ID, brokerDTO.getIp(), brokerDTO.getPort(), brokerDTO.getDataCenter(), brokerDTO.getRetryType(), brokerDTO.getPermission(), brokerDTO.getId());
        return brokerDTO;
    }

    public int deleteById(long id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

