/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.ConfigDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class ConfigRepository {
    private static final String TABLE = "config";
    private static final String COLUMNS = "id, key, value, `group`";
    private static final String UPDATE_COLUMNS = "key = ?, value = ?, `group` = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, key, value, `group`", "config");
    private static final String GET_BY_KEY_AND_GROUP = String.format("SELECT %s FROM %s WHERE key = ? AND `group` = ? ORDER BY key", "id, key, value, `group`", "config");
    private static final String GET_ALL = String.format("SELECT %s FROM %s ORDER BY key", "id, key, value, `group`", "config");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?)", "config", "id, key, value, `group`");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "config", "key = ?, value = ?, `group` = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "config");
    private BaseRepository baseRepository;

    public ConfigRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public ConfigDTO getById(String id) {
        return this.baseRepository.queryOnce(ConfigDTO.class, GET_BY_ID, id);
    }

    public ConfigDTO getByKeyAndGroup(String key, String group) {
        return this.baseRepository.queryOnce(ConfigDTO.class, GET_BY_KEY_AND_GROUP, key, group);
    }

    public List<ConfigDTO> getAll() {
        return this.baseRepository.query(ConfigDTO.class, GET_ALL, new Object[0]);
    }

    public ConfigDTO add(ConfigDTO configDTO) {
        this.baseRepository.insert(ADD, configDTO.getId(), configDTO.getKey(), configDTO.getValue(), configDTO.getGroup());
        return configDTO;
    }

    public ConfigDTO update(ConfigDTO configDTO) {
        this.baseRepository.update(UPDATE_BY_ID, configDTO.getKey(), configDTO.getValue(), configDTO.getGroup(), configDTO.getId());
        return configDTO;
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

