/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.ConsumerDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class ConsumerRepository {
    private static final String TABLE = "consumer";
    private static final String COLUMNS = "id, topic, namespace, app, topic_type, client_type, referer, `group`, consume_policy, retry_policy, limit_policy";
    private static final String UPDATE_COLUMNS = "topic = ?, namespace = ?, app = ?, topic_type = ?, client_type = ?, referer = ?, consume_policy = ?, retry_policy = ?, limit_policy = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, topic, namespace, app, topic_type, client_type, referer, `group`, consume_policy, retry_policy, limit_policy", "consumer");
    private static final String GET_BY_TOPIC_AND_APP = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ? AND app = ? ORDER BY id", "id, topic, namespace, app, topic_type, client_type, referer, `group`, consume_policy, retry_policy, limit_policy", "consumer");
    private static final String GET_BY_TOPIC = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ? ORDER BY id", "id, topic, namespace, app, topic_type, client_type, referer, `group`, consume_policy, retry_policy, limit_policy", "consumer");
    private static final String GET_BY_APP = String.format("SELECT %s FROM %s WHERE app = ? OR referer = ? ORDER BY id", "id, topic, namespace, app, topic_type, client_type, referer, `group`, consume_policy, retry_policy, limit_policy", "consumer");
    private static final String GET_ALL = String.format("SELECT %s FROM %s ORDER BY id", "id, topic, namespace, app, topic_type, client_type, referer, `group`, consume_policy, retry_policy, limit_policy", "consumer");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?,?,?,?,?,?,?)", "consumer", "id, topic, namespace, app, topic_type, client_type, referer, `group`, consume_policy, retry_policy, limit_policy");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "consumer", "topic = ?, namespace = ?, app = ?, topic_type = ?, client_type = ?, referer = ?, consume_policy = ?, retry_policy = ?, limit_policy = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "consumer");
    private BaseRepository baseRepository;

    public ConsumerRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public ConsumerDTO getById(String id) {
        return this.baseRepository.queryOnce(ConsumerDTO.class, GET_BY_ID, id);
    }

    public ConsumerDTO getByTopicAndApp(String topic, String namespace, String app) {
        return this.baseRepository.queryOnce(ConsumerDTO.class, GET_BY_TOPIC_AND_APP, topic, namespace, app);
    }

    public List<ConsumerDTO> getByTopic(String topic, String namespace) {
        return this.baseRepository.query(ConsumerDTO.class, GET_BY_TOPIC, topic, namespace);
    }

    public List<ConsumerDTO> getByApp(String app) {
        return this.baseRepository.query(ConsumerDTO.class, GET_BY_APP, app, app);
    }

    public List<ConsumerDTO> getAll() {
        return this.baseRepository.query(ConsumerDTO.class, GET_ALL, new Object[0]);
    }

    public ConsumerDTO add(ConsumerDTO consumerDTO) {
        this.baseRepository.insert(ADD, consumerDTO.getId(), consumerDTO.getTopic(), consumerDTO.getNamespace(), consumerDTO.getApp(), consumerDTO.getTopicType(), consumerDTO.getClientType(), consumerDTO.getReferer(), consumerDTO.getGroup(), consumerDTO.getConsumePolicy(), consumerDTO.getRetryPolicy(), consumerDTO.getLimitPolicy());
        return consumerDTO;
    }

    public ConsumerDTO update(ConsumerDTO consumerDTO) {
        this.baseRepository.update(UPDATE_BY_ID, consumerDTO.getTopic(), consumerDTO.getNamespace(), consumerDTO.getApp(), consumerDTO.getTopicType(), consumerDTO.getClientType(), consumerDTO.getReferer(), consumerDTO.getConsumePolicy(), consumerDTO.getRetryPolicy(), consumerDTO.getLimitPolicy(), consumerDTO.getId());
        return consumerDTO;
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

