/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.DataCenterDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class DataCenterRepository {
    private static final String TABLE = "datacenter";
    private static final String COLUMNS = "id, region, code, name, url";
    private static final String UPDATE_COLUMNS = "region = ?, code = ?, name = ?, url = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, region, code, name, url", "datacenter");
    private static final String GET_ALL = String.format("SELECT %s FROM %s ORDER BY code", "id, region, code, name, url", "datacenter");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?)", "datacenter", "id, region, code, name, url");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "datacenter", "region = ?, code = ?, name = ?, url = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "datacenter");
    private BaseRepository baseRepository;

    public DataCenterRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public DataCenterDTO getById(String id) {
        return this.baseRepository.queryOnce(DataCenterDTO.class, GET_BY_ID, id);
    }

    public List<DataCenterDTO> getAll() {
        return this.baseRepository.query(DataCenterDTO.class, GET_ALL, new Object[0]);
    }

    public DataCenterDTO add(DataCenterDTO dataCenterDTO) {
        this.baseRepository.insert(ADD, dataCenterDTO.getId(), dataCenterDTO.getRegion(), dataCenterDTO.getCode(), dataCenterDTO.getName(), dataCenterDTO.getUrl());
        return dataCenterDTO;
    }

    public DataCenterDTO update(DataCenterDTO dataCenterDTO) {
        this.baseRepository.update(UPDATE_BY_ID, dataCenterDTO.getRegion(), dataCenterDTO.getCode(), dataCenterDTO.getName(), dataCenterDTO.getUrl(), dataCenterDTO.getId());
        return dataCenterDTO;
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

