/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.NamespaceDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class NamespaceRepository {
    private static final String TABLE = "namespace";
    private static final String COLUMNS = "id, code, name";
    private static final String UPDATE_COLUMNS = "code = ?, name = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ? ORDER BY code", "id, code, name", "namespace");
    private static final String GET_BY_CODE = String.format("SELECT %s FROM %s WHERE code = ?", "id, code, name", "namespace");
    private static final String GET_ALL = String.format("SELECT %s FROM %s ORDER BY code", "id, code, name", "namespace");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?)", "namespace", "id, code, name");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "namespace", "code = ?, name = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "namespace");
    private BaseRepository baseRepository;

    public NamespaceRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public NamespaceDTO getById(String id) {
        return this.baseRepository.queryOnce(NamespaceDTO.class, GET_BY_ID, id);
    }

    public NamespaceDTO getByCode(String code) {
        return this.baseRepository.queryOnce(NamespaceDTO.class, GET_BY_CODE, code);
    }

    public List<NamespaceDTO> getAll() {
        return this.baseRepository.query(NamespaceDTO.class, GET_ALL, new Object[0]);
    }

    public NamespaceDTO add(NamespaceDTO namespaceDTO) {
        this.baseRepository.insert(ADD, namespaceDTO.getId(), namespaceDTO.getCode(), namespaceDTO.getName());
        return namespaceDTO;
    }

    public NamespaceDTO update(NamespaceDTO namespaceDTO) {
        this.baseRepository.update(UPDATE_BY_ID, namespaceDTO.getCode(), namespaceDTO.getName(), namespaceDTO.getId());
        return namespaceDTO;
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

