/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.PartitionGroupReplicaDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class PartitionGroupReplicaRepository {
    private static final String TABLE = "partition_group_replica";
    private static final String COLUMNS = "id, topic, namespace, broker_id, `group`";
    private static final String UPDATE_COLUMNS = "topic = ?, namespace = ?, broker_id = ?, `group` = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, topic, namespace, broker_id, `group`", "partition_group_replica");
    private static final String GET_BY_TOPIC = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ?", "id, topic, namespace, broker_id, `group`", "partition_group_replica");
    private static final String GET_BY_TOPIC_AND_GROUP = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ? AND `group` = ?", "id, topic, namespace, broker_id, `group`", "partition_group_replica");
    private static final String GET_BY_BROKER = String.format("SELECT %s FROM %s WHERE broker_id = ?", "id, topic, namespace, broker_id, `group`", "partition_group_replica");
    private static final String GET_ALL = String.format("SELECT %s FROM %s", "id, topic, namespace, broker_id, `group`", "partition_group_replica");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?)", "partition_group_replica", "id, topic, namespace, broker_id, `group`");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "partition_group_replica", "topic = ?, namespace = ?, broker_id = ?, `group` = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "partition_group_replica");
    private BaseRepository baseRepository;

    public PartitionGroupReplicaRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public PartitionGroupReplicaDTO getById(String id) {
        return this.baseRepository.queryOnce(PartitionGroupReplicaDTO.class, GET_BY_ID, id);
    }

    public List<PartitionGroupReplicaDTO> getByTopic(String topic, String namespace) {
        return this.baseRepository.query(PartitionGroupReplicaDTO.class, GET_BY_TOPIC, topic, namespace);
    }

    public List<PartitionGroupReplicaDTO> getByTopicAndGroup(String topic, String namespace, int group) {
        return this.baseRepository.query(PartitionGroupReplicaDTO.class, GET_BY_TOPIC_AND_GROUP, topic, namespace, group);
    }

    public List<PartitionGroupReplicaDTO> getByBrokerId(long brokerId) {
        return this.baseRepository.query(PartitionGroupReplicaDTO.class, GET_BY_BROKER, brokerId);
    }

    public List<PartitionGroupReplicaDTO> getAll() {
        return this.baseRepository.query(PartitionGroupReplicaDTO.class, GET_ALL, new Object[0]);
    }

    public PartitionGroupReplicaDTO add(PartitionGroupReplicaDTO partitionGroupReplicaDTO) {
        this.baseRepository.insert(ADD, partitionGroupReplicaDTO.getId(), partitionGroupReplicaDTO.getTopic(), partitionGroupReplicaDTO.getNamespace(), partitionGroupReplicaDTO.getBrokerId(), partitionGroupReplicaDTO.getGroup());
        return partitionGroupReplicaDTO;
    }

    public PartitionGroupReplicaDTO update(PartitionGroupReplicaDTO partitionGroupReplicaDTO) {
        this.baseRepository.update(UPDATE_BY_ID, partitionGroupReplicaDTO.getTopic(), partitionGroupReplicaDTO.getNamespace(), partitionGroupReplicaDTO.getBrokerId(), partitionGroupReplicaDTO.getGroup(), partitionGroupReplicaDTO.getId());
        return partitionGroupReplicaDTO;
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

