/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.PartitionGroupDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class PartitionGroupRepository {
    private static final String TABLE = "partition_group";
    private static final String COLUMNS = "id, namespace, topic, `group`, leader, isrs, term, partitions, learners, replicas, out_sync_replicas, elect_type, rec_leader";
    private static final String UPDATE_COLUMNS = "namespace = ?, topic = ?, `group` = ?, leader = ?, isrs = ?, term = ?, partitions = ?, learners = ?, replicas = ?, out_sync_replicas = ?, elect_type = ?, rec_leader = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, namespace, topic, `group`, leader, isrs, term, partitions, learners, replicas, out_sync_replicas, elect_type, rec_leader", "partition_group");
    private static final String GET_BY_TOPIC_AND_GROUP = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ? AND `group` = ? ORDER BY `group`", "id, namespace, topic, `group`, leader, isrs, term, partitions, learners, replicas, out_sync_replicas, elect_type, rec_leader", "partition_group");
    private static final String GET_BY_TOPIC = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ? ORDER BY `group`", "id, namespace, topic, `group`, leader, isrs, term, partitions, learners, replicas, out_sync_replicas, elect_type, rec_leader", "partition_group");
    private static final String GET_ALL = String.format("SELECT %s FROM %s", "id, namespace, topic, `group`, leader, isrs, term, partitions, learners, replicas, out_sync_replicas, elect_type, rec_leader", "partition_group");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)", "partition_group", "id, namespace, topic, `group`, leader, isrs, term, partitions, learners, replicas, out_sync_replicas, elect_type, rec_leader");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "partition_group", "namespace = ?, topic = ?, `group` = ?, leader = ?, isrs = ?, term = ?, partitions = ?, learners = ?, replicas = ?, out_sync_replicas = ?, elect_type = ?, rec_leader = ?");
    private static final String UPDATE_LEADER_BY_ID = String.format("UPDATE %s SET leader = ?, term = ?, isrs = ? WHERE id = ?", "partition_group");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "partition_group");
    private BaseRepository baseRepository;

    public PartitionGroupRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public PartitionGroupDTO getById(String id) {
        return this.baseRepository.queryOnce(PartitionGroupDTO.class, GET_BY_ID, id);
    }

    public PartitionGroupDTO getByTopicAndGroup(String topic, String namespace, int group) {
        return this.baseRepository.queryOnce(PartitionGroupDTO.class, GET_BY_TOPIC_AND_GROUP, topic, namespace, group);
    }

    public List<PartitionGroupDTO> getByTopic(String topic, String namespace) {
        return this.baseRepository.query(PartitionGroupDTO.class, GET_BY_TOPIC, topic, namespace);
    }

    public List<PartitionGroupDTO> getAll() {
        return this.baseRepository.query(PartitionGroupDTO.class, GET_ALL, new Object[0]);
    }

    public PartitionGroupDTO add(PartitionGroupDTO partitionGroupDTO) {
        this.baseRepository.insert(ADD, partitionGroupDTO.getId(), partitionGroupDTO.getNamespace(), partitionGroupDTO.getTopic(), partitionGroupDTO.getGroup(), partitionGroupDTO.getLeader(), partitionGroupDTO.getIsrs(), partitionGroupDTO.getTerm(), partitionGroupDTO.getPartitions(), partitionGroupDTO.getLearners(), partitionGroupDTO.getReplicas(), partitionGroupDTO.getOutSyncReplicas(), partitionGroupDTO.getElectType(), partitionGroupDTO.getRecLeader());
        return partitionGroupDTO;
    }

    public PartitionGroupDTO updateLeader(PartitionGroupDTO partitionGroupDTO) {
        this.baseRepository.update(UPDATE_LEADER_BY_ID, partitionGroupDTO.getLeader(), partitionGroupDTO.getTerm(), partitionGroupDTO.getIsrs(), partitionGroupDTO.getId());
        return partitionGroupDTO;
    }

    public PartitionGroupDTO update(PartitionGroupDTO partitionGroupDTO) {
        this.baseRepository.update(UPDATE_BY_ID, partitionGroupDTO.getNamespace(), partitionGroupDTO.getTopic(), partitionGroupDTO.getGroup(), partitionGroupDTO.getLeader(), partitionGroupDTO.getIsrs(), partitionGroupDTO.getTerm(), partitionGroupDTO.getPartitions(), partitionGroupDTO.getLearners(), partitionGroupDTO.getReplicas(), partitionGroupDTO.getOutSyncReplicas(), partitionGroupDTO.getElectType(), partitionGroupDTO.getRecLeader(), partitionGroupDTO.getId());
        return partitionGroupDTO;
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

