/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.List;
import org.joyqueue.nsr.journalkeeper.domain.ProducerDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;

public class ProducerRepository {
    private static final String TABLE = "producer";
    private static final String COLUMNS = "id, topic, namespace, app, client_type, produce_policy, limit_policy";
    private static final String UPDATE_COLUMNS = "topic = ?, namespace = ?, app = ?, client_type = ?, produce_policy = ?, limit_policy = ?";
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, topic, namespace, app, client_type, produce_policy, limit_policy", "producer");
    private static final String GET_BY_TOPIC_AND_APP = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ? AND app = ? ORDER BY id", "id, topic, namespace, app, client_type, produce_policy, limit_policy", "producer");
    private static final String GET_BY_TOPIC = String.format("SELECT %s FROM %s WHERE topic = ? AND namespace = ? ORDER BY id", "id, topic, namespace, app, client_type, produce_policy, limit_policy", "producer");
    private static final String GET_BY_APP = String.format("SELECT %s FROM %s WHERE app = ? ORDER BY id", "id, topic, namespace, app, client_type, produce_policy, limit_policy", "producer");
    private static final String GET_ALL = String.format("SELECT %s FROM %s", "id, topic, namespace, app, client_type, produce_policy, limit_policy", "producer");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?,?,?)", "producer", "id, topic, namespace, app, client_type, produce_policy, limit_policy");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "producer", "topic = ?, namespace = ?, app = ?, client_type = ?, produce_policy = ?, limit_policy = ?");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "producer");
    private BaseRepository baseRepository;

    public ProducerRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public ProducerDTO getById(String id) {
        return this.baseRepository.queryOnce(ProducerDTO.class, GET_BY_ID, id);
    }

    public ProducerDTO getByTopicAndApp(String topic, String namespace, String app) {
        return this.baseRepository.queryOnce(ProducerDTO.class, GET_BY_TOPIC_AND_APP, topic, namespace, app);
    }

    public List<ProducerDTO> getByTopic(String topic, String namespace) {
        return this.baseRepository.query(ProducerDTO.class, GET_BY_TOPIC, topic, namespace);
    }

    public List<ProducerDTO> getByApp(String app) {
        return this.baseRepository.query(ProducerDTO.class, GET_BY_APP, app);
    }

    public List<ProducerDTO> getAll() {
        return this.baseRepository.query(ProducerDTO.class, GET_ALL, new Object[0]);
    }

    public ProducerDTO add(ProducerDTO consumerDTO) {
        this.baseRepository.insert(ADD, consumerDTO.getId(), consumerDTO.getTopic(), consumerDTO.getNamespace(), consumerDTO.getApp(), consumerDTO.getClientType(), consumerDTO.getProducePolicy(), consumerDTO.getLimitPolicy());
        return consumerDTO;
    }

    public ProducerDTO update(ProducerDTO consumerDTO) {
        this.baseRepository.update(UPDATE_BY_ID, consumerDTO.getTopic(), consumerDTO.getNamespace(), consumerDTO.getApp(), consumerDTO.getClientType(), consumerDTO.getProducePolicy(), consumerDTO.getLimitPolicy(), consumerDTO.getId());
        return consumerDTO;
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

