/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.repository;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.nsr.journalkeeper.domain.TopicDTO;
import org.joyqueue.nsr.journalkeeper.repository.BaseRepository;
import org.joyqueue.nsr.model.TopicQuery;

public class TopicRepository {
    private static final String TABLE = "topic";
    private static final String COLUMNS = "id, code, namespace, partitions, priority_partitions, type";
    private static final String UPDATE_COLUMNS = "code = ?, namespace = ?, partitions = ?, priority_partitions = ?, type = ?";
    private static final String GET_ALL = String.format("SELECT %s FROM %s ORDER BY code", "id, code, namespace, partitions, priority_partitions, type", "topic");
    private static final String GET_BY_CODE = String.format("SELECT %s FROM %s WHERE code = ? AND namespace = ?", "id, code, namespace, partitions, priority_partitions, type", "topic");
    private static final String GET_BY_ID = String.format("SELECT %s FROM %s WHERE id = ?", "id, code, namespace, partitions, priority_partitions, type", "topic");
    private static final String ADD = String.format("INSERT INTO %s(%s) VALUES(?,?,?,?,?,?)", "topic", "id, code, namespace, partitions, priority_partitions, type");
    private static final String UPDATE_BY_ID = String.format("UPDATE %s SET %s WHERE id = ?", "topic", "code = ?, namespace = ?, partitions = ?, priority_partitions = ?, type = ?");
    private static final String UPDATE_INCR_PARTITION_BY_ID = String.format("UPDATE %s SET partitions = partitions + ? WHERE id = ?", "topic");
    private static final String UPDATE_DECR_PARTITION_BY_ID = String.format("UPDATE %s SET partitions = partitions - ? WHERE id = ?", "topic");
    private static final String DELETE_BY_ID = String.format("DELETE FROM %s WHERE id = ?", "topic");
    private BaseRepository baseRepository;

    public TopicRepository(BaseRepository baseRepository) {
        this.baseRepository = baseRepository;
    }

    public List<TopicDTO> getAll() {
        return this.baseRepository.query(TopicDTO.class, GET_ALL, new Object[0]);
    }

    public TopicDTO getByCodeAndNamespace(String code, String namespace) {
        return this.baseRepository.queryOnce(TopicDTO.class, GET_BY_CODE, code, namespace);
    }

    public TopicDTO getById(String id) {
        return this.baseRepository.queryOnce(TopicDTO.class, GET_BY_ID, id);
    }

    public int getSearchCount(TopicQuery query) {
        LinkedList<Object> params = new LinkedList<Object>();
        String sql = this.getSearchSql(String.format("SELECT COUNT(*) FROM %s WHERE 1 = 1", TABLE), query, params);
        return this.baseRepository.count(sql, params.toArray(new Object[0]));
    }

    public List<TopicDTO> search(QPageQuery<TopicQuery> pageQuery) {
        Pagination pagination = pageQuery.getPagination();
        LinkedList<Object> params = new LinkedList<Object>();
        StringBuilder sql = new StringBuilder(this.getSearchSql(String.format("SELECT %s FROM %s WHERE 1 = 1", COLUMNS, TABLE), (TopicQuery)pageQuery.getQuery(), params));
        if (pagination != null) {
            sql.append(String.format(" LIMIT %s, %s", (pagination.getPage() - 1) * pagination.getSize(), pagination.getSize()));
        }
        return this.baseRepository.query(TopicDTO.class, sql.toString(), params.toArray(new Object[0]));
    }

    protected String getSearchSql(String prefix, TopicQuery query, List<Object> params) {
        StringBuilder sql = new StringBuilder(prefix);
        if (StringUtils.isNotBlank((CharSequence)query.getCode())) {
            sql.append(" AND code = ?");
            params.add(query.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getNamespace())) {
            sql.append(" AND namespace = ?");
            params.add(query.getNamespace());
        }
        if (query.getType() != null) {
            sql.append(" AND type = ?");
            params.add(query.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getKeyword())) {
            sql.append(" AND code LIKE ?");
            params.add("%" + query.getKeyword() + "%");
        }
        return sql.toString();
    }

    public TopicDTO add(TopicDTO topicDTO) {
        this.baseRepository.insert(ADD, topicDTO.getId(), topicDTO.getCode(), topicDTO.getNamespace(), topicDTO.getPartitions(), topicDTO.getPriorityPartitions(), topicDTO.getType());
        return topicDTO;
    }

    public TopicDTO update(TopicDTO topicDTO) {
        this.baseRepository.update(UPDATE_BY_ID, topicDTO.getCode(), topicDTO.getNamespace(), topicDTO.getPartitions(), topicDTO.getPriorityPartitions(), topicDTO.getType(), topicDTO.getId());
        return topicDTO;
    }

    public int incrPartitions(String id, int value) {
        return this.baseRepository.update(UPDATE_INCR_PARTITION_BY_ID, value, id);
    }

    public int decrPartitions(String id, int value) {
        return this.baseRepository.update(UPDATE_DECR_PARTITION_BY_ID, value, id);
    }

    public int deleteById(String id) {
        return this.baseRepository.delete(DELETE_BY_ID, id);
    }
}

