/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.service;

import java.util.List;
import org.joyqueue.domain.Broker;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.nsr.journalkeeper.converter.BrokerConverter;
import org.joyqueue.nsr.journalkeeper.domain.BrokerDTO;
import org.joyqueue.nsr.journalkeeper.repository.BrokerRepository;
import org.joyqueue.nsr.model.BrokerQuery;
import org.joyqueue.nsr.service.internal.BrokerInternalService;

public class JournalkeeperBrokerInternalService
implements BrokerInternalService {
    private BrokerRepository brokerRepository;

    public JournalkeeperBrokerInternalService(BrokerRepository brokerRepository) {
        this.brokerRepository = brokerRepository;
    }

    public Broker getByIpAndPort(String brokerIp, Integer brokerPort) {
        return BrokerConverter.convert(this.brokerRepository.getByIpAndPort(brokerIp, brokerPort));
    }

    public List<Broker> getByRetryType(String retryType) {
        return BrokerConverter.convert(this.brokerRepository.getByRetryType(retryType));
    }

    public List<Broker> getByIds(List<Integer> ids) {
        return BrokerConverter.convert(this.brokerRepository.getByIds(ids));
    }

    public Broker update(Broker broker) {
        return BrokerConverter.convert(this.brokerRepository.update(BrokerConverter.convert(broker)));
    }

    public Broker getById(int id) {
        return BrokerConverter.convert(this.brokerRepository.getById(id));
    }

    public Broker add(Broker broker) {
        return BrokerConverter.convert(this.brokerRepository.add(BrokerConverter.convert(broker)));
    }

    public void delete(int id) {
        this.brokerRepository.deleteById(id);
    }

    public List<Broker> getAll() {
        return BrokerConverter.convert(this.brokerRepository.getAll());
    }

    public PageResult<Broker> search(QPageQuery<BrokerQuery> pageQuery) {
        int count = this.brokerRepository.getSearchCount((BrokerQuery)pageQuery.getQuery());
        List<BrokerDTO> brokers = null;
        if (count != 0) {
            brokers = this.brokerRepository.search(pageQuery);
        }
        Pagination pagination = pageQuery.getPagination();
        pagination.setTotalRecord(count);
        PageResult result = new PageResult();
        result.setPagination(pagination);
        result.setResult(BrokerConverter.convert(brokers));
        return result;
    }
}

