/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.journalkeeper.core.api.ClusterConfiguration;
import io.journalkeeper.core.api.ServerStatus;
import io.journalkeeper.sql.client.SQLClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joyqueue.nsr.exception.NsrException;
import org.joyqueue.nsr.service.internal.ClusterInternalService;
import org.joyqueue.toolkit.network.IpUtil;

public class JournalkeeperClusterInternalService
implements ClusterInternalService {
    private SQLClient sqlClient;

    public JournalkeeperClusterInternalService(SQLClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    public String getCluster() {
        try {
            HashMap result = Maps.newHashMap();
            ClusterConfiguration clusterConfiguration = (ClusterConfiguration)this.sqlClient.getAdminClient().getClusterConfiguration().get();
            for (URI voter : clusterConfiguration.getVoters()) {
                if (!voter.getHost().equals(IpUtil.getLocalIp())) continue;
                ServerStatus serverStatus = (ServerStatus)this.sqlClient.getAdminClient().getServerStatus(voter).get();
                result.put("status", serverStatus);
            }
            result.put("cluster", clusterConfiguration);
            return JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        catch (Exception e) {
            throw new NsrException((Throwable)e);
        }
    }

    public String addNode(URI uri) {
        try {
            ClusterConfiguration clusterConfiguration = (ClusterConfiguration)this.sqlClient.getAdminClient().getClusterConfiguration().get();
            List oldConfig = clusterConfiguration.getVoters();
            ArrayList newConfig = Lists.newArrayList((Iterable)oldConfig);
            newConfig.add(uri);
            this.sqlClient.getAdminClient().updateVoters(oldConfig, (List)newConfig);
            return String.format("{'oldConfig':'%s', 'newConfig':'%s'}", oldConfig, newConfig);
        }
        catch (Exception e) {
            throw new NsrException((Throwable)e);
        }
    }

    public String removeNode(URI uri) {
        try {
            ClusterConfiguration clusterConfiguration = (ClusterConfiguration)this.sqlClient.getAdminClient().getClusterConfiguration().get();
            List oldConfig = clusterConfiguration.getVoters();
            ArrayList newConfig = Lists.newArrayList((Iterable)oldConfig);
            newConfig.remove(uri);
            this.sqlClient.getAdminClient().updateVoters(oldConfig, (List)newConfig);
            return String.format("{'oldConfig':'%s', 'newConfig':'%s'}", oldConfig, newConfig);
        }
        catch (Exception e) {
            throw new NsrException((Throwable)e);
        }
    }

    public String updateNodes(List<URI> uris) {
        try {
            ClusterConfiguration clusterConfiguration = (ClusterConfiguration)this.sqlClient.getAdminClient().getClusterConfiguration().get();
            List oldConfig = clusterConfiguration.getVoters();
            List<URI> newConfig = uris;
            this.sqlClient.getAdminClient().updateVoters(oldConfig, newConfig);
            return String.format("{'oldConfig':'%s', 'newConfig':'%s'}", oldConfig, newConfig);
        }
        catch (Exception e) {
            throw new NsrException((Throwable)e);
        }
    }

    public String execute(String command, List<String> args) {
        try {
            String result = null;
            switch (command) {
                case "getSnapshots": {
                    result = this.sqlClient.getAdminClient().getSnapshots().get();
                    break;
                }
                case "takeSnapshot": {
                    this.sqlClient.getAdminClient().takeSnapshot().get();
                    result = "success";
                    break;
                }
                case "recoverSnapshot": {
                    this.sqlClient.getAdminClient().recoverSnapshot((long)Integer.valueOf(args.get(0)).intValue()).get();
                    result = "success";
                    break;
                }
                default: {
                    result = "unsupported";
                }
            }
            return JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        catch (Exception e) {
            throw new NsrException((Throwable)e);
        }
    }
}

