/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.service;

import java.util.List;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.journalkeeper.converter.ConsumerConverter;
import org.joyqueue.nsr.journalkeeper.domain.ConsumerDTO;
import org.joyqueue.nsr.journalkeeper.repository.ConsumerRepository;
import org.joyqueue.nsr.service.internal.ConsumerInternalService;

public class JournalkeeperConsumerInternalService
implements ConsumerInternalService {
    private ConsumerRepository consumerRepository;

    public JournalkeeperConsumerInternalService(ConsumerRepository consumerRepository) {
        this.consumerRepository = consumerRepository;
    }

    public Consumer getById(String id) {
        return ConsumerConverter.convert(this.consumerRepository.getById(id));
    }

    public Consumer getByTopicAndApp(TopicName topic, String app) {
        return ConsumerConverter.convert(this.consumerRepository.getByTopicAndApp(topic.getCode(), topic.getNamespace(), app));
    }

    public List<Consumer> getByTopic(TopicName topic) {
        return ConsumerConverter.convert(this.consumerRepository.getByTopic(topic.getCode(), topic.getNamespace()));
    }

    public List<Consumer> getByApp(String app) {
        return ConsumerConverter.convert(this.consumerRepository.getByApp(app));
    }

    public List<Consumer> getAll() {
        return ConsumerConverter.convert(this.consumerRepository.getAll());
    }

    public Consumer add(Consumer consumer) {
        ConsumerDTO consumerDTO = ConsumerConverter.convert(consumer);
        return ConsumerConverter.convert(this.consumerRepository.add(consumerDTO));
    }

    public Consumer update(Consumer consumer) {
        return ConsumerConverter.convert(this.consumerRepository.update(ConsumerConverter.convert(consumer)));
    }

    public void delete(String id) {
        this.consumerRepository.deleteById(id);
    }
}

