/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.service;

import java.util.List;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.nsr.journalkeeper.converter.ProducerConverter;
import org.joyqueue.nsr.journalkeeper.repository.ProducerRepository;
import org.joyqueue.nsr.service.internal.ProducerInternalService;

public class JournalkeeperProducerInternalService
implements ProducerInternalService {
    private ProducerRepository producerRepository;

    public JournalkeeperProducerInternalService(ProducerRepository producerRepository) {
        this.producerRepository = producerRepository;
    }

    public Producer getById(String id) {
        return ProducerConverter.convert(this.producerRepository.getById(id));
    }

    public Producer getByTopicAndApp(TopicName topic, String app) {
        return ProducerConverter.convert(this.producerRepository.getByTopicAndApp(topic.getCode(), topic.getNamespace(), app));
    }

    public List<Producer> getByTopic(TopicName topic) {
        return ProducerConverter.convert(this.producerRepository.getByTopic(topic.getCode(), topic.getNamespace()));
    }

    public List<Producer> getByApp(String app) {
        return ProducerConverter.convert(this.producerRepository.getByApp(app));
    }

    public List<Producer> getAll() {
        return ProducerConverter.convert(this.producerRepository.getAll());
    }

    public Producer add(Producer producer) {
        return ProducerConverter.convert(this.producerRepository.add(ProducerConverter.convert(producer)));
    }

    public Producer update(Producer producer) {
        return ProducerConverter.convert(this.producerRepository.update(ProducerConverter.convert(producer)));
    }

    public void delete(String id) {
        this.producerRepository.deleteById(id);
    }
}

