/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.nsr.journalkeeper.service;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Topic;
import org.joyqueue.model.PageResult;
import org.joyqueue.model.Pagination;
import org.joyqueue.model.QPageQuery;
import org.joyqueue.nsr.journalkeeper.converter.PartitionGroupConverter;
import org.joyqueue.nsr.journalkeeper.converter.PartitionGroupReplicaConverter;
import org.joyqueue.nsr.journalkeeper.converter.TopicConverter;
import org.joyqueue.nsr.journalkeeper.domain.PartitionGroupDTO;
import org.joyqueue.nsr.journalkeeper.domain.PartitionGroupReplicaDTO;
import org.joyqueue.nsr.journalkeeper.domain.TopicDTO;
import org.joyqueue.nsr.journalkeeper.repository.PartitionGroupReplicaRepository;
import org.joyqueue.nsr.journalkeeper.repository.PartitionGroupRepository;
import org.joyqueue.nsr.journalkeeper.repository.TopicRepository;
import org.joyqueue.nsr.model.TopicQuery;
import org.joyqueue.nsr.service.internal.TopicInternalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalkeeperTopicInternalService
implements TopicInternalService {
    protected static final Logger logger = LoggerFactory.getLogger(JournalkeeperTopicInternalService.class);
    private TopicRepository topicRepository;
    private PartitionGroupRepository partitionGroupRepository;
    private PartitionGroupReplicaRepository partitionGroupReplicaRepository;

    public JournalkeeperTopicInternalService(TopicRepository topicRepository, PartitionGroupRepository partitionGroupRepository, PartitionGroupReplicaRepository partitionGroupReplicaRepository) {
        this.topicRepository = topicRepository;
        this.partitionGroupRepository = partitionGroupRepository;
        this.partitionGroupReplicaRepository = partitionGroupReplicaRepository;
    }

    public Topic getById(String id) {
        return TopicConverter.convert(this.topicRepository.getById(id));
    }

    public Topic getTopicByCode(String namespace, String topic) {
        return TopicConverter.convert(this.topicRepository.getByCodeAndNamespace(topic, namespace));
    }

    public PageResult<Topic> search(QPageQuery<TopicQuery> pageQuery) {
        int count = this.topicRepository.getSearchCount((TopicQuery)pageQuery.getQuery());
        List<TopicDTO> topics = null;
        if (count != 0) {
            topics = this.topicRepository.search(pageQuery);
        }
        Pagination pagination = pageQuery.getPagination();
        pagination.setTotalRecord(count);
        PageResult result = new PageResult();
        result.setPagination(pagination);
        result.setResult(TopicConverter.convert(topics));
        return result;
    }

    public PageResult<Topic> findUnsubscribedByQuery(QPageQuery<TopicQuery> pageQuery) {
        return this.search(pageQuery);
    }

    public List<Topic> getAll() {
        return TopicConverter.convert(this.topicRepository.getAll());
    }

    public void addTopic(Topic topic, List<PartitionGroup> partitionGroups) {
        this.topicRepository.add(TopicConverter.convert(topic));
        for (PartitionGroup partitionGroup : partitionGroups) {
            this.partitionGroupRepository.add(PartitionGroupConverter.convert(partitionGroup));
            for (Integer replica : partitionGroup.getReplicas()) {
                this.partitionGroupReplicaRepository.add(new PartitionGroupReplicaDTO(PartitionGroupReplicaConverter.generateId(topic.getName().getFullName(), partitionGroup.getGroup(), replica), topic.getName().getCode(), topic.getName().getNamespace(), Long.valueOf(String.valueOf(replica)), partitionGroup.getGroup()));
            }
        }
    }

    public void removeTopic(Topic topic) {
        TopicDTO topicDTO = this.topicRepository.getByCodeAndNamespace(topic.getName().getCode(), topic.getName().getNamespace());
        List<PartitionGroupDTO> partitionGroups = this.partitionGroupRepository.getByTopic(topicDTO.getCode(), topicDTO.getNamespace());
        List<PartitionGroupReplicaDTO> partitionGroupReplicas = this.partitionGroupReplicaRepository.getByTopic(topicDTO.getCode(), topicDTO.getNamespace());
        for (PartitionGroupDTO partitionGroup : partitionGroups) {
            this.partitionGroupRepository.deleteById(partitionGroup.getId());
        }
        for (PartitionGroupReplicaDTO partitionGroupReplica : partitionGroupReplicas) {
            this.partitionGroupReplicaRepository.deleteById(partitionGroupReplica.getId());
        }
        this.topicRepository.deleteById(topicDTO.getId());
    }

    public void addPartitionGroup(PartitionGroup group) {
        TopicDTO topicDTO = this.topicRepository.getByCodeAndNamespace(group.getTopic().getCode(), group.getTopic().getNamespace());
        this.partitionGroupRepository.add(PartitionGroupConverter.convert(group));
        for (Integer replica : group.getReplicas()) {
            this.partitionGroupReplicaRepository.add(new PartitionGroupReplicaDTO(PartitionGroupReplicaConverter.generateId(group.getTopic().getFullName(), group.getGroup(), replica), group.getTopic().getCode(), group.getTopic().getNamespace(), Long.valueOf(String.valueOf(replica)), group.getGroup()));
        }
        this.topicRepository.incrPartitions(topicDTO.getId(), group.getPartitions().size());
    }

    public void removePartitionGroup(PartitionGroup group) {
        TopicDTO topicDTO = this.topicRepository.getByCodeAndNamespace(group.getTopic().getCode(), group.getTopic().getNamespace());
        PartitionGroupDTO partitionGroup = this.partitionGroupRepository.getByTopicAndGroup(group.getTopic().getCode(), group.getTopic().getNamespace(), group.getGroup());
        List<PartitionGroupReplicaDTO> partitionGroupReplicas = this.partitionGroupReplicaRepository.getByTopicAndGroup(topicDTO.getCode(), topicDTO.getNamespace(), group.getGroup());
        this.partitionGroupRepository.deleteById(partitionGroup.getId());
        for (PartitionGroupReplicaDTO partitionGroupReplica : partitionGroupReplicas) {
            this.partitionGroupReplicaRepository.deleteById(partitionGroupReplica.getId());
        }
        this.topicRepository.decrPartitions(topicDTO.getId(), group.getPartitions().size());
    }

    public Collection<Integer> updatePartitionGroup(PartitionGroup group) {
        TopicDTO topicDTO = this.topicRepository.getByCodeAndNamespace(group.getTopic().getCode(), group.getTopic().getNamespace());
        PartitionGroupDTO oldPartitionGroupDTO = this.partitionGroupRepository.getByTopicAndGroup(group.getTopic().getCode(), group.getTopic().getNamespace(), group.getGroup());
        PartitionGroup oldPartitionGroup = PartitionGroupConverter.convert(oldPartitionGroupDTO);
        List<PartitionGroupReplicaDTO> partitionGroupReplicas = this.partitionGroupReplicaRepository.getByTopicAndGroup(group.getTopic().getCode(), group.getTopic().getNamespace(), group.getGroup());
        for (PartitionGroupReplicaDTO partitionGroupReplica : partitionGroupReplicas) {
            if (group.getReplicas().contains(partitionGroupReplica.getBrokerId())) continue;
            this.partitionGroupReplicaRepository.deleteById(partitionGroupReplica.getId());
        }
        for (Integer replica : group.getReplicas()) {
            boolean isMatch = false;
            for (PartitionGroupReplicaDTO partitionGroupReplica : partitionGroupReplicas) {
                if (!partitionGroupReplica.getBrokerId().equals(replica)) continue;
                isMatch = true;
                break;
            }
            if (isMatch) continue;
            this.partitionGroupReplicaRepository.add(new PartitionGroupReplicaDTO(PartitionGroupReplicaConverter.generateId(group.getTopic().getFullName(), group.getGroup(), replica), group.getTopic().getCode(), group.getTopic().getNamespace(), Long.valueOf(String.valueOf(replica)), group.getGroup()));
        }
        this.partitionGroupRepository.update(PartitionGroupConverter.convert(group));
        if (group.getPartitions().size() != oldPartitionGroup.getPartitions().size()) {
            this.topicRepository.incrPartitions(topicDTO.getId(), group.getPartitions().size() - oldPartitionGroup.getPartitions().size());
        }
        return Collections.emptyList();
    }

    public void leaderReport(PartitionGroup group) {
        this.partitionGroupRepository.updateLeader(PartitionGroupConverter.convert(group));
    }

    public void leaderChange(PartitionGroup group) {
    }

    public List<PartitionGroup> getPartitionGroup(String namespace, String topic, Object[] groups) {
        LinkedList result = Lists.newLinkedList();
        for (Object group : groups) {
            PartitionGroupDTO partitionGroupDTO = this.partitionGroupRepository.getByTopicAndGroup(topic, namespace, Integer.valueOf(String.valueOf(group)));
            if (partitionGroupDTO == null) continue;
            result.add(PartitionGroupConverter.convert(partitionGroupDTO));
        }
        return result;
    }

    public Topic add(Topic topic) {
        return TopicConverter.convert(this.topicRepository.add(TopicConverter.convert(topic)));
    }

    public Topic update(Topic topic) {
        return TopicConverter.convert(this.topicRepository.update(TopicConverter.convert(topic)));
    }
}

