/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.annotation.Value;
import com.jd.laf.binding.binder.Binder;
import com.jd.laf.binding.converter.Scope;
import com.jd.laf.binding.reflect.FieldAccessorFactory;
import com.jd.laf.binding.reflect.Fields;
import com.jd.laf.binding.reflect.MethodFactory;
import com.jd.laf.binding.reflect.MethodParameter;
import com.jd.laf.binding.reflect.PropertySupplier;
import com.jd.laf.binding.reflect.Reflect;
import com.jd.laf.binding.reflect.exception.ReflectionException;
import com.jd.laf.binding.util.Collections;
import com.jd.laf.binding.util.Function;
import com.jd.laf.binding.util.Predicate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class Binding {
    protected static ConcurrentMap<Class<?>, List<BindingScope>> FIELDS = new ConcurrentHashMap();
    protected static ConcurrentMap<Class<?>, ConcurrentMap<Method, List<BindingScope>>> METHODS = new ConcurrentHashMap();

    public static boolean set(Object target, String field, Object value) throws ReflectionException {
        return Binding.set(target, field, value, (FieldAccessorFactory)Plugin.FIELD.get());
    }

    public static boolean set(Object target, String field, Object value, FieldAccessorFactory factory) throws ReflectionException {
        if (field == null || target == null || factory == null) {
            return false;
        }
        return Binding.set(target, Fields.getField(target.getClass(), field), value, factory);
    }

    public static boolean set(Object target, Field field, Object value) throws ReflectionException {
        return Binding.set(target, field, value, (FieldAccessorFactory)Plugin.FIELD.get());
    }

    public static boolean set(Object target, Field field, Object value, FieldAccessorFactory factory) throws ReflectionException {
        if (field == null || factory == null) {
            return false;
        }
        return Reflect.set(target, field, value, factory);
    }

    public static boolean support(Class<?> source, Class<?> target) {
        return Reflect.support(source, target);
    }

    public static boolean support(Class<?> source, Class<?> target, Scope scope) {
        return Reflect.support(source, target, scope);
    }

    public static void bind(Object source, Object target) throws ReflectionException {
        Binding.bind(source, target, NoneFinalField.INSTANCE, (FieldAccessorFactory)Plugin.FIELD.get());
    }

    public static void bind(Object source, Object target, FieldAccessorFactory factory) throws ReflectionException {
        Binding.bind(source, target, NoneFinalField.INSTANCE, factory);
    }

    public static void bind(Object source, Object target, final Predicate<Field> predicate, final FieldAccessorFactory factory) throws ReflectionException {
        if (source == null || target == null) {
            return;
        }
        Class<?> clazz = target.getClass();
        List<BindingScope> bindings = Collections.computeIfAbsent(FIELDS, clazz, new Function<Class<?>, List<BindingScope>>(){

            @Override
            public List<BindingScope> apply(Class<?> clazz) {
                ArrayList<BindingScope> bindings = new ArrayList<BindingScope>();
                Predicate myPredicate = predicate == null ? NoneFinalField.INSTANCE : predicate;
                FieldAccessorFactory myFactory = factory == null ? (FieldAccessorFactory)Plugin.FIELD.get() : factory;
                List<Field> fields = Fields.getFields(clazz);
                if (fields != null) {
                    for (Field field : fields) {
                        Annotation[] annotations;
                        if (!myPredicate.test(field)) continue;
                        BindingScope bindingField = null;
                        for (Annotation annotation : annotations = field.getAnnotations()) {
                            Binder binder = (Binder)Plugin.BINDER.get(annotation.annotationType());
                            if (binder == null) continue;
                            if (bindingField == null) {
                                bindingField = new BindingScope(new Scope.FieldScope(clazz, field, myFactory.getAccessor(field)), new PropertySupplier.FieldSupplier(factory));
                            }
                            bindingField.add(new BinderAnnotation(annotation, binder));
                        }
                        if (bindingField == null) continue;
                        bindings.add(bindingField);
                    }
                }
                return bindings;
            }
        });
        for (BindingScope binding : bindings) {
            binding.bind(source, target);
        }
    }

    public static Object[] bind(Object source, Object target, Method method) throws ReflectionException {
        return Binding.bind(source, target, method, (PropertySupplier)null);
    }

    public static Object[] bind(Object source, Object target, Method method, final PropertySupplier supplier) throws ReflectionException {
        if (source == null || method == null) {
            return null;
        }
        final MethodFactory methodFactory = (MethodFactory)Plugin.METHOD_FACTORY.get();
        Object[] args = new Object[methodFactory.getParameterCount(method)];
        final Class<?> targetClass = target.getClass();
        ConcurrentMap<Method, List<BindingScope>> methods = Collections.computeIfAbsent(METHODS, targetClass, new Function<Class<?>, ConcurrentMap<Method, List<BindingScope>>>(){

            @Override
            public ConcurrentMap<Method, List<BindingScope>> apply(Class<?> key) {
                return new ConcurrentHashMap<Method, List<BindingScope>>();
            }
        });
        List<BindingScope> bindings = Collections.computeIfAbsent(methods, method, new Function<Method, List<BindingScope>>(){

            @Override
            public List<BindingScope> apply(Method method) {
                ArrayList<BindingScope> bindings = new ArrayList<BindingScope>();
                List<MethodParameter> parameters = methodFactory.getParameters(targetClass, method);
                for (final MethodParameter parameter : parameters) {
                    Annotation[] annotations;
                    BindingScope bindingScope = new BindingScope(new Scope.ParameterScope(parameter), supplier);
                    for (Annotation annotation : annotations = parameter.getAnnotations()) {
                        Binder binder = (Binder)Plugin.BINDER.get(annotation.annotationType());
                        if (binder == null) continue;
                        bindingScope.add(new BinderAnnotation(annotation, binder));
                    }
                    if (bindingScope.isEmpty()) {
                        bindingScope.add(new BinderAnnotation(new Value(){

                            @Override
                            public String value() {
                                return parameter.getName();
                            }

                            @Override
                            public String format() {
                                return "";
                            }

                            @Override
                            public boolean nullable() {
                                return false;
                            }

                            @Override
                            public String defaultValue() {
                                return "";
                            }

                            @Override
                            public Class<? extends Annotation> annotationType() {
                                return Value.class;
                            }
                        }, (Binder)Plugin.BINDER.get(Value.class)));
                    }
                    bindings.add(bindingScope);
                }
                return bindings;
            }
        });
        for (BindingScope binding : bindings) {
            binding.bind(source, args);
        }
        return args;
    }

    public static class NoneFinalField
    implements Predicate<Field> {
        public static final Predicate<Field> INSTANCE = new NoneFinalField();

        @Override
        public boolean test(Field obj) {
            return !Modifier.isFinal(obj.getModifiers());
        }
    }

    protected static class BinderAnnotation {
        protected final Annotation annotation;
        protected final Binder binder;

        public BinderAnnotation(Annotation annotation, Binder binder) {
            this.annotation = annotation;
            this.binder = binder;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public Binder getBinder() {
            return this.binder;
        }
    }

    protected static class BindingScope {
        protected final Scope scope;
        protected final PropertySupplier supplier;
        protected final List<BinderAnnotation> annotations = new ArrayList<BinderAnnotation>(2);

        public BindingScope(Scope scope, PropertySupplier supplier) {
            this.scope = scope;
            this.supplier = supplier;
        }

        public void add(BinderAnnotation annotation) {
            if (annotation != null) {
                this.annotations.add(annotation);
            }
        }

        public boolean isEmpty() {
            return this.annotations.isEmpty();
        }

        public void bind(Object source, Object target) throws ReflectionException {
            for (BinderAnnotation annotation : this.annotations) {
                Binder.Context context = new Binder.Context(source, target, annotation.annotation, this.scope, this.supplier);
                if (!annotation.binder.bind(context)) continue;
                return;
            }
        }
    }
}

