/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter;

import com.jd.laf.binding.reflect.FieldAccessor;
import com.jd.laf.binding.reflect.GenericMeta;
import com.jd.laf.binding.reflect.Generics;
import com.jd.laf.binding.reflect.MethodParameter;
import com.jd.laf.binding.reflect.exception.ReflectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public interface Scope {
    public String getName();

    public Annotation[] getAnnotations();

    public GenericMeta[] getGenericMetas();

    public Class getGenericType();

    public Class getType();

    public Object target();

    public void update(Object var1, Object var2) throws ReflectionException;

    public static class ParameterScope
    implements Scope {
        protected final MethodParameter parameter;

        public ParameterScope(MethodParameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public String getName() {
            return this.parameter.getName();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.parameter.getAnnotations();
        }

        @Override
        public Class getType() {
            return this.parameter.getType();
        }

        @Override
        public GenericMeta[] getGenericMetas() {
            return this.parameter.getGenericMetas();
        }

        @Override
        public Class getGenericType() {
            GenericMeta[] genericMetas = this.getGenericMetas();
            return genericMetas.length != 1 ? null : genericMetas[0].getClazz();
        }

        @Override
        public Object target() {
            return this.parameter.target();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterScope that = (ParameterScope)o;
            return this.parameter.equals(that.parameter);
        }

        public int hashCode() {
            return this.parameter.hashCode();
        }

        @Override
        public void update(Object target, Object value) throws ReflectionException {
            if (target != null) {
                ((Object[])target)[this.parameter.getIndex()] = value;
            }
        }
    }

    public static class FieldScope
    extends AbstractScope {
        protected Class owner;
        protected Field field;
        protected FieldAccessor accessor;

        public FieldScope(Class owner, Field field, FieldAccessor accessor) {
            this.annotations = field.getAnnotations();
            this.owner = owner;
            this.field = field;
            this.accessor = accessor;
            this.genericMetas = Generics.get(owner).get(field);
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public Class getType() {
            return this.field.getType();
        }

        @Override
        public Object target() {
            return this.field;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldScope that = (FieldScope)o;
            return this.field.equals(that.field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        @Override
        public void update(Object target, Object value) throws ReflectionException {
            this.accessor.set(target, value);
        }
    }

    public static abstract class AbstractScope
    implements Scope {
        protected Annotation[] annotations;
        protected GenericMeta[] genericMetas;

        @Override
        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        @Override
        public GenericMeta[] getGenericMetas() {
            return this.genericMetas;
        }

        @Override
        public Class getGenericType() {
            return this.genericMetas.length != 1 ? null : this.genericMetas[0].getClazz();
        }
    }
}

