/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.simple.NumberConverter;
import java.util.concurrent.atomic.AtomicBoolean;

public class AtomicBooleanConverter
extends NumberConverter {
    public AtomicBoolean execute(Conversion conversion) {
        if (conversion == null || conversion.source == null) {
            return null;
        }
        if (conversion.source instanceof Number) {
            return new AtomicBoolean(((Number)conversion.source).intValue() != 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        if (conversion.source instanceof Character) {
            return new AtomicBoolean(((Character)conversion.source).charValue() != '0' ? Boolean.TRUE : Boolean.FALSE);
        }
        if (conversion.source instanceof CharSequence) {
            String value = conversion.source.toString().trim();
            if ("true".equalsIgnoreCase(value)) {
                return new AtomicBoolean(true);
            }
            if ("false".equalsIgnoreCase(value)) {
                return new AtomicBoolean(false);
            }
            try {
                return new AtomicBoolean(Long.parseLong(value) != 0L);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Class<?> targetType() {
        return AtomicBoolean.class;
    }
}

