/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.simple.NumberConverter;

public class BooleanConverter
extends NumberConverter {
    public Boolean execute(Conversion conversion) {
        if (conversion == null || conversion.source == null) {
            return null;
        }
        if (conversion.source instanceof Number) {
            return ((Number)conversion.source).intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (conversion.source instanceof Character) {
            return ((Character)conversion.source).charValue() != '0' ? Boolean.TRUE : Boolean.FALSE;
        }
        if (conversion.source instanceof CharSequence) {
            String value = conversion.source.toString().trim();
            if ("true".equalsIgnoreCase(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return Boolean.FALSE;
            }
            try {
                return Long.parseLong(value) != 0L;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Class<?> targetType() {
        return Boolean.class;
    }
}

