/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.SimpleConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateConverter
implements SimpleConverter {
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String HH_MM_SS = "HH:mm:ss";
    protected static ThreadLocal<Map<String, DateFormat>> threadLocal = new ThreadLocal<Map<String, DateFormat>>(){

        @Override
        protected Map<String, DateFormat> initialValue() {
            return new HashMap<String, DateFormat>();
        }
    };

    protected static DateFormat getDateFormat(String format) {
        if (format == null || format.isEmpty()) {
            return null;
        }
        Map<String, DateFormat> formats = threadLocal.get();
        DateFormat result = formats.get(format);
        if (result == null) {
            result = new SimpleDateFormat(format);
            formats.put(format, result);
        }
        return result;
    }

    public Date execute(Conversion conversion) {
        if (conversion == null || conversion.source == null) {
            return null;
        }
        if (conversion.source instanceof Calendar) {
            return ((Calendar)conversion.source).getTime();
        }
        if (conversion.source instanceof Number) {
            return new Date(((Number)conversion.source).longValue());
        }
        if (conversion.source instanceof CharSequence) {
            String format;
            String source = ((CharSequence)conversion.source).toString().trim();
            String string = format = conversion.format == null ? null : conversion.format.toString();
            if (format == null || format.isEmpty()) {
                switch (source.length()) {
                    case 19: {
                        format = YYYY_MM_DD_HH_MM_SS;
                        break;
                    }
                    case 10: {
                        format = YYYY_MM_DD;
                        break;
                    }
                    case 8: {
                        format = HH_MM_SS;
                        break;
                    }
                    default: {
                        format = null;
                    }
                }
            }
            if (format != null) {
                try {
                    DateFormat sdf = DateConverter.getDateFormat(format);
                    return sdf.parse(source);
                }
                catch (ParseException e) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public boolean support(Class<?> sourceType) {
        if (sourceType == null) {
            return false;
        }
        if (Calendar.class.isAssignableFrom(sourceType)) {
            return true;
        }
        if (Number.class.isAssignableFrom(sourceType)) {
            return true;
        }
        return CharSequence.class.isAssignableFrom(sourceType);
    }

    @Override
    public Class<?> targetType() {
        return Date.class;
    }
}

