/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.SimpleConverter;
import com.jd.laf.binding.util.Strings;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Properties;

public class StringConverter
implements SimpleConverter {
    public String execute(Conversion conversion) {
        if (conversion == null) {
            return null;
        }
        Object value = conversion.source;
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (value instanceof Properties) {
            return this.onProperties((Properties)value);
        }
        if (value instanceof Collection) {
            return this.onCollection((Collection)value);
        }
        if (value.getClass().isArray()) {
            return this.onArray(value);
        }
        return value.toString();
    }

    protected String onProperties(Properties value) {
        return Strings.toString(value);
    }

    protected String onArray(Object value) {
        int length = Array.getLength(value);
        StringBuilder builder = new StringBuilder(100);
        for (int i = 0; i < length; ++i) {
            Object item;
            if (i > 0) {
                builder.append(',');
            }
            if ((item = Array.get(value, i)) == null) continue;
            builder.append(item.toString());
        }
        return builder.toString();
    }

    protected String onCollection(Collection<?> value) {
        StringBuilder builder = new StringBuilder(100);
        Collection<?> collection = value;
        int count = 0;
        for (Object item : collection) {
            if (count++ > 0) {
                builder.append(',');
            }
            if (item == null) continue;
            builder.append(item.toString());
        }
        return builder.toString();
    }

    @Override
    public boolean support(Class<?> sourceType) {
        return true;
    }

    @Override
    public Class<?> targetType() {
        return String.class;
    }
}

