/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.reflect.array.ArrayObject;
import com.jd.laf.binding.reflect.array.supplier.ArraySupplier;
import com.jd.laf.binding.util.Primitive;

public class Array2ArraySupplier
implements ConverterSupplier {
    @Override
    public Converter getConverter(ConversionType type) {
        if (type.targetType.isArray() && type.sourceType.isArray()) {
            return Array2ArrayOperation.INSTANCE;
        }
        return null;
    }

    public int order() {
        return 99;
    }

    protected static final class Array2ArrayOperation
    implements Converter {
        protected static final Converter INSTANCE = new Array2ArrayOperation();

        protected Array2ArrayOperation() {
        }

        public Object execute(Conversion conversion) throws Exception {
            Class<?> targetComponentType = conversion.targetType.getComponentType();
            Class<?> sourceComponentType = conversion.sourceType.getComponentType();
            Class<?> inboxTargetComponentType = Primitive.inbox(targetComponentType);
            Class<?> inboxSourceComponentType = Primitive.inbox(sourceComponentType);
            if (inboxTargetComponentType == null || inboxSourceComponentType == null) {
                return null;
            }
            if (inboxTargetComponentType.equals(inboxSourceComponentType) || inboxTargetComponentType.isAssignableFrom(inboxSourceComponentType)) {
                return conversion.source;
            }
            Converter componentOperation = (Converter)Plugin.CONVERTER.select((Object)new ConversionType(inboxSourceComponentType, inboxTargetComponentType));
            ArraySupplier srcArraySupplier = (ArraySupplier)Plugin.ARRAY.select(sourceComponentType);
            ArraySupplier targetArraySupplier = (ArraySupplier)Plugin.ARRAY.select(targetComponentType);
            ArrayObject srcArray = srcArraySupplier.wrap(conversion.source);
            int size = srcArray.length();
            ArrayObject targetArray = targetArraySupplier.create(size);
            Class<?> lastInboxSourceElementType = null;
            Converter op = null;
            for (int i = 0; i < size; ++i) {
                Object obj;
                Object element = srcArray.get(i);
                if (element == null) {
                    if (targetComponentType.isPrimitive()) {
                        return null;
                    }
                    targetArray.set(i, null);
                    continue;
                }
                if (componentOperation != null) {
                    obj = componentOperation.execute(new Conversion(inboxSourceComponentType, inboxTargetComponentType, element, conversion.format));
                } else {
                    Class<?> inboxSourceElementType = Primitive.inbox(element.getClass());
                    Converter converter = op = inboxSourceElementType.equals(lastInboxSourceElementType) ? op : (Converter)Plugin.CONVERTER.select((Object)new ConversionType(inboxSourceElementType, inboxTargetComponentType));
                    if (op == null) {
                        return null;
                    }
                    obj = op.execute(new Conversion(inboxSourceElementType, inboxTargetComponentType, element, conversion.format));
                    lastInboxSourceElementType = inboxSourceElementType;
                }
                if (obj == null) {
                    return null;
                }
                targetArray.set(i, obj);
            }
            return targetArray.getArray();
        }
    }
}

