/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.reflect.array.ArrayObject;
import com.jd.laf.binding.reflect.array.supplier.ArraySupplier;
import com.jd.laf.binding.util.Collections;
import com.jd.laf.binding.util.Primitive;
import java.util.Collection;

public class Array2CollectionSupplier
implements ConverterSupplier {
    @Override
    public Converter getConverter(ConversionType type) {
        if (Collection.class.isAssignableFrom(type.targetType) && type.sourceType.isArray()) {
            return Array2CollectionOperation.INSTANCE;
        }
        return null;
    }

    public int order() {
        return 99;
    }

    protected static final class Array2CollectionOperation
    implements Converter {
        protected static final Converter INSTANCE = new Array2CollectionOperation();

        protected Array2CollectionOperation() {
        }

        public Object execute(Conversion conversion) throws Exception {
            Class<?> inboxTargetComponentType = Primitive.inbox(conversion.scope.getGenericType());
            if (inboxTargetComponentType == null) {
                return null;
            }
            Class<?> sourceComponentType = conversion.sourceType.getComponentType();
            Class<?> inboxSourceComponentType = Primitive.inbox(sourceComponentType);
            ArraySupplier srcArraySupplier = (ArraySupplier)Plugin.ARRAY.select(sourceComponentType);
            ArrayObject srcArray = srcArraySupplier.wrap(conversion.source);
            int size = srcArray.length();
            Collection result = Collections.create(conversion.targetType, size);
            if (result == null) {
                return null;
            }
            Converter componentOperation = (Converter)Plugin.CONVERTER.select((Object)new ConversionType(inboxSourceComponentType, inboxTargetComponentType));
            Converter op = null;
            Class<?> lastInboxSourceElementType = null;
            for (int i = 0; i < size; ++i) {
                Object obj;
                Object element = srcArray.get(i);
                if (element == null) {
                    if (inboxTargetComponentType.isPrimitive()) {
                        return null;
                    }
                    result.add(null);
                    continue;
                }
                if (componentOperation != null) {
                    obj = componentOperation.execute(new Conversion(inboxSourceComponentType, inboxTargetComponentType, element, conversion.format));
                } else {
                    Class<?> inboxSourceElementType = Primitive.inbox(element.getClass());
                    Converter converter = op = inboxSourceElementType.equals(lastInboxSourceElementType) ? op : (Converter)Plugin.CONVERTER.select((Object)new ConversionType(inboxSourceElementType, inboxTargetComponentType));
                    if (op == null) {
                        return null;
                    }
                    obj = op.execute(new Conversion(inboxSourceElementType, inboxTargetComponentType, element, conversion.format));
                    lastInboxSourceElementType = inboxSourceElementType;
                }
                if (obj == null) {
                    return null;
                }
                result.add(obj);
            }
            return result;
        }
    }
}

