/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.reflect.array.ArrayObject;
import com.jd.laf.binding.reflect.array.supplier.ArraySupplier;
import com.jd.laf.binding.util.Primitive;
import java.util.Collection;

public class Collection2ArraySupplier
implements ConverterSupplier {
    @Override
    public Converter getConverter(ConversionType type) {
        if (type.targetType.isArray() && Collection.class.isAssignableFrom(type.sourceType)) {
            return Collection2ArrayOperation.INSTANCE;
        }
        return null;
    }

    public int order() {
        return 99;
    }

    protected static final class Collection2ArrayOperation
    implements Converter {
        protected static final Converter INSTANCE = new Collection2ArrayOperation();

        protected Collection2ArrayOperation() {
        }

        public Object execute(Conversion conversion) throws Exception {
            Class<?> targetComponentType = conversion.targetType.getComponentType();
            Class<?> inboxTargetComponentType = Primitive.inbox(targetComponentType);
            if (inboxTargetComponentType == null) {
                return null;
            }
            Class<?> lastInboxSourceComponentType = null;
            Collection value = (Collection)conversion.source;
            Object format = conversion.format;
            int size = value.size();
            ArraySupplier arraySupplier = (ArraySupplier)Plugin.ARRAY.select(targetComponentType);
            ArrayObject array = arraySupplier.create(size);
            Converter operation = null;
            int count = 0;
            for (Object v : value) {
                if (v == null) {
                    if (targetComponentType.isPrimitive()) {
                        return false;
                    }
                    array.set(count++, null);
                    continue;
                }
                Class<?> inboxSourceComponentType = Primitive.inbox(v.getClass());
                operation = inboxSourceComponentType.equals(lastInboxSourceComponentType) ? operation : (Converter)Plugin.CONVERTER.select((Object)new ConversionType(inboxSourceComponentType, inboxTargetComponentType));
                Object obj = operation.execute(new Conversion(inboxSourceComponentType, inboxTargetComponentType, v, format));
                if (obj == null) {
                    return false;
                }
                array.set(count++, obj);
                lastInboxSourceComponentType = inboxSourceComponentType;
            }
            return array.getArray();
        }
    }
}

