/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.util.Collections;
import com.jd.laf.binding.util.Primitive;
import java.util.Collection;

public class Collection2CollectionSupplier
implements ConverterSupplier {
    @Override
    public Converter getConverter(ConversionType type) {
        if (Collection.class.isAssignableFrom(type.targetType) && Collection.class.isAssignableFrom(type.sourceType)) {
            return Collection2CollectionOperation.INSTANCE;
        }
        return null;
    }

    public int order() {
        return 99;
    }

    protected static final class Collection2CollectionOperation
    implements Converter {
        protected static final Converter INSTANCE = new Collection2CollectionOperation();

        protected Collection2CollectionOperation() {
        }

        public Object execute(Conversion conversion) throws Exception {
            Class<?> inboxTargetComponentType = Primitive.inbox(conversion.scope.getGenericType());
            if (inboxTargetComponentType == null) {
                return null;
            }
            Collection value = (Collection)conversion.source;
            int size = value.size();
            Collection result = Collections.create(conversion.targetType, size);
            if (result == null) {
                return null;
            }
            Object format = conversion.format;
            Class<?> lastInboxSourceComponentType = null;
            Converter operation = null;
            for (Object v : value) {
                if (v == null) {
                    result.add(null);
                    continue;
                }
                Class<?> inboxSourceComponentType = Primitive.inbox(v.getClass());
                operation = inboxSourceComponentType.equals(lastInboxSourceComponentType) ? operation : (Converter)Plugin.CONVERTER.select((Object)new ConversionType(inboxSourceComponentType, inboxTargetComponentType));
                Object obj = operation.execute(new Conversion(inboxSourceComponentType, inboxTargetComponentType, v, format));
                if (obj == null) {
                    return false;
                }
                lastInboxSourceComponentType = inboxSourceComponentType;
                result.add(obj);
            }
            return result;
        }
    }
}

