/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.reflect.Constructors;
import com.jd.laf.binding.reflect.Fields;
import com.jd.laf.binding.reflect.Reflect;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class Map2ObjectSupplier
implements ConverterSupplier {
    @Override
    public Converter getConverter(ConversionType type) {
        Class<?> targetType = type.targetType;
        if (!Map.class.isAssignableFrom(type.sourceType) || Object.class.equals(targetType) || Map.class.isAssignableFrom(targetType) || Collection.class.isAssignableFrom(targetType) || targetType.isArray() || targetType.isInterface() || targetType.isPrimitive() || targetType.isEnum() || Modifier.isAbstract(targetType.getModifiers())) {
            return null;
        }
        return Map2ObjectOperation.INSTANCE;
    }

    public int order() {
        return 50;
    }

    protected static class Map2ObjectOperation
    implements Converter {
        protected static final Converter INSTANCE = new Map2ObjectOperation();

        protected Map2ObjectOperation() {
        }

        public Object execute(Conversion conversion) throws Exception {
            Constructor constructor = Constructors.getDefaultConstructor(conversion.targetType);
            if (constructor == null) {
                return null;
            }
            Object obj = constructor.newInstance(new Object[0]);
            ConcurrentMap<String, Field> fields = Fields.getNames(conversion.targetType);
            if (!fields.isEmpty()) {
                for (Map.Entry entry : ((Map)conversion.source).entrySet()) {
                    Field field;
                    Object key = entry.getKey();
                    if (key == null || !(key instanceof CharSequence) || (field = (Field)fields.get(key.toString())) == null) continue;
                    Reflect.set(obj, field, entry.getValue());
                }
            }
            return obj;
        }
    }
}

