/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.util.Primitive;
import com.jd.laf.extension.Option;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class StaticMethodSupplier
implements ConverterSupplier {
    protected final String methodName;

    public StaticMethodSupplier(String methodName) {
        if (methodName == null || methodName.isEmpty()) {
            throw new IllegalArgumentException("methodName can not be empty.");
        }
        this.methodName = methodName;
    }

    @Override
    public Converter getConverter(ConversionType type) {
        Method method = StaticMethodSupplier.getMethod(type.targetType, type.sourceType, this.methodName, this.getCache());
        return method == null ? null : new Converter.MethodConverter(method);
    }

    protected abstract ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, Option<Method>>> getCache();

    protected static Method getMethod(Class<?> targetType, Class<?> parameterType, String methodName, ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, Option<Method>>> cache) throws SecurityException {
        Option option;
        ConcurrentMap exist;
        if (targetType == null || targetType.isInterface() || parameterType == null) {
            return null;
        }
        ConcurrentMap<Class<?>, Option> options = (ConcurrentHashMap)cache.get(targetType);
        if (options == null && (exist = (ConcurrentMap)cache.putIfAbsent(targetType, options = new ConcurrentHashMap())) != null) {
            options = exist;
        }
        if ((option = (Option)options.get(parameterType)) == null) {
            Option exist2;
            Method[] methods;
            Method method = null;
            for (Method c : methods = targetType.getMethods()) {
                Class<?>[] parameters = c.getParameterTypes();
                if (!Modifier.isStatic(c.getModifiers()) || !Modifier.isPublic(c.getModifiers()) || !c.getName().equals(methodName) || !targetType.isAssignableFrom(c.getReturnType()) || parameters.length != 1 || !Primitive.inbox(parameters[0]).isAssignableFrom(parameterType)) continue;
                method = c;
                break;
            }
            if ((exist2 = options.putIfAbsent(parameterType, option = new Option(method))) != null) {
                option = exist2;
            }
        }
        return (Method)option.get();
    }
}

