/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.reflect.array.ArrayObject;
import com.jd.laf.binding.reflect.array.supplier.ArraySupplier;
import com.jd.laf.binding.util.Primitive;
import com.jd.laf.binding.util.Strings;
import java.util.List;

public class String2ArraySupplier
implements ConverterSupplier {
    @Override
    public Converter getConverter(ConversionType type) {
        if (type.targetType.isArray() && CharSequence.class.isAssignableFrom(type.sourceType)) {
            return String2ArrayOperation.INSTANCE;
        }
        return null;
    }

    public int order() {
        return 99;
    }

    protected static final class String2ArrayOperation
    implements Converter {
        protected static final Converter INSTANCE = new String2ArrayOperation();

        protected String2ArrayOperation() {
        }

        public Object execute(Conversion conversion) throws Exception {
            Class<?> targetElementType = conversion.targetType.getComponentType();
            Class<?> inboxElementType = Primitive.inbox(targetElementType);
            Converter operation = (Converter)Plugin.CONVERTER.select((Object)new ConversionType(String.class, inboxElementType));
            if (operation == null) {
                return null;
            }
            Object format = conversion.format;
            List<String> parts = Strings.split(conversion.source.toString(), format == null ? null : format.toString());
            ArraySupplier arraySupplier = (ArraySupplier)Plugin.ARRAY.select(targetElementType);
            ArrayObject array = arraySupplier.create(parts.size());
            int pos = 0;
            for (String part : parts) {
                if (part != null) {
                    part = part.trim();
                }
                if (part == null || part.isEmpty()) {
                    if (targetElementType.isPrimitive()) {
                        return null;
                    }
                    array.set(pos++, null);
                    continue;
                }
                Object obj = operation.execute(new Conversion(String.class, inboxElementType, part));
                if (obj == null) {
                    return null;
                }
                array.set(pos++, obj);
            }
            return array.getArray();
        }
    }
}

