/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.supplier;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.ConverterSupplier;
import com.jd.laf.binding.util.Collections;
import com.jd.laf.binding.util.Primitive;
import com.jd.laf.binding.util.Strings;
import java.util.Collection;
import java.util.List;

public class String2CollectionSupplier
implements ConverterSupplier {
    @Override
    public Converter getConverter(ConversionType type) {
        if (Collection.class.isAssignableFrom(type.targetType) && CharSequence.class.isAssignableFrom(type.sourceType)) {
            return String2CollectionOperation.INSTANCE;
        }
        return null;
    }

    public int order() {
        return 99;
    }

    protected static final class String2CollectionOperation
    implements Converter {
        protected static final Converter INSTANCE = new String2CollectionOperation();

        protected String2CollectionOperation() {
        }

        public Object execute(Conversion conversion) throws Exception {
            Class<?> inboxTargetComponentType = Primitive.inbox(conversion.scope.getGenericType());
            if (inboxTargetComponentType == null) {
                return null;
            }
            Converter operation = (Converter)Plugin.CONVERTER.select((Object)new ConversionType(String.class, inboxTargetComponentType));
            if (operation == null) {
                return null;
            }
            Object format = conversion.format;
            List<String> parts = Strings.split(conversion.source.toString(), format == null ? null : format.toString());
            Collection result = Collections.create(conversion.targetType, parts.size());
            if (result == null) {
                return null;
            }
            for (String part : parts) {
                if (part != null) {
                    part = part.trim();
                }
                if (part == null || part.isEmpty()) {
                    result.add(null);
                    continue;
                }
                Object obj = operation.execute(new Conversion(String.class, inboxTargetComponentType, part));
                if (obj == null) {
                    return null;
                }
                result.add(obj);
            }
            return result;
        }
    }
}

