/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.marshaller;

import com.jd.laf.binding.marshaller.Marshaller;
import com.jd.laf.binding.marshaller.TypeReference;
import com.jd.laf.binding.marshaller.Unmarshaller;
import com.jd.laf.binding.marshaller.XmlProvider;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;

public class JaxbProvider
implements XmlProvider {
    protected static final ConcurrentMap<Class, JAXBContext> contexts = new ConcurrentHashMap<Class, JAXBContext>();

    @Override
    public Unmarshaller getUnmarshaller() {
        return JaxbUnmarshaller.INSTANCE;
    }

    @Override
    public Marshaller getMarshaller() {
        return JaxbMarshaller.INSTANCE;
    }

    protected static JAXBContext getJaxbContext(Class clazz) throws JAXBException {
        JAXBContext exists;
        if (clazz == null) {
            return null;
        }
        JAXBContext context = (JAXBContext)contexts.get(clazz);
        if (context == null && (exists = contexts.putIfAbsent(clazz, context = JAXBContext.newInstance((Class[])new Class[]{clazz}))) != null) {
            context = exists;
        }
        return context;
    }

    protected static class JaxbMarshaller
    implements Marshaller {
        protected static final Marshaller INSTANCE = new JaxbMarshaller();

        protected JaxbMarshaller() {
        }

        @Override
        public String marshall(Object target) throws Exception {
            if (target == null) {
                return null;
            }
            JAXBContext context = JaxbProvider.getJaxbContext(target.getClass());
            javax.xml.bind.Marshaller marshaller = context.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal(target, (Writer)writer);
            return writer.toString();
        }
    }

    protected static class JaxbUnmarshaller
    implements Unmarshaller {
        public static final Unmarshaller INSTANCE = new JaxbUnmarshaller();

        protected JaxbUnmarshaller() {
        }

        @Override
        public <T> T unmarshall(String value, Class<T> clazz, String format) throws Exception {
            return this.unmarshall(value, clazz);
        }

        @Override
        public <T> T unmarshall(String value, Class<T> clazz) throws Exception {
            if (value == null || value.isEmpty()) {
                return null;
            }
            XmlRootElement annotation = clazz.getAnnotation(XmlRootElement.class);
            if (annotation == null) {
                return null;
            }
            JAXBContext context = JaxbProvider.getJaxbContext(clazz);
            javax.xml.bind.Unmarshaller marshaller = context.createUnmarshaller();
            return (T)marshaller.unmarshal((Reader)new StringReader(value));
        }

        @Override
        public <T> T unmarshall(String value, TypeReference<T> reference, String format) throws Exception {
            return this.unmarshall(value, (Class)reference.getType());
        }

        @Override
        public <T> T unmarshall(String value, TypeReference<T> reference) throws Exception {
            return this.unmarshall(value, (Class)reference.getType());
        }
    }
}

