/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.marshaller;

import com.jd.laf.binding.reflect.ParameterizedTypeImpl;
import com.jd.laf.binding.util.Collections;
import com.jd.laf.binding.util.Function;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class TypeReference<T> {
    protected static ConcurrentMap<Type, Type> TYPE = new ConcurrentHashMap<Type, Type>(16, 0.75f, 1);
    public static final Type LIST_STRING = new TypeReference<List<String>>(){}.getType();
    protected final Type type;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.type = this.putIfAbsent(type);
    }

    protected TypeReference(Type rawType, Type[] argTypes) {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(argTypes, this.getClass(), rawType);
        this.type = this.putIfAbsent(type);
    }

    protected TypeReference(Type ... actualTypeArguments) {
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        Type type = this.handle(thisClass, argType, actualTypeArguments, 0);
        this.type = this.putIfAbsent(type);
    }

    protected Type putIfAbsent(Type type) {
        return Collections.computeIfAbsent(TYPE, type, new Function<Type, Type>(){

            @Override
            public Type apply(Type key) {
                return key;
            }
        });
    }

    protected Type handle(Class<?> thisClass, ParameterizedType type, Type[] actualTypeArguments, int actualIndex) {
        Type[] types = type.getActualTypeArguments();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                types[i] = actualTypeArguments[actualIndex++];
            }
            if (types[i] instanceof GenericArrayType) {
                types[i] = this.checkPrimitiveArray((GenericArrayType)types[i]);
            }
            if (!(types[i] instanceof ParameterizedType)) continue;
            types[i] = this.handle(thisClass, (ParameterizedType)types[i], actualTypeArguments, actualIndex);
        }
        return new ParameterizedTypeImpl(types, thisClass, type.getRawType());
    }

    protected Type checkPrimitiveArray(GenericArrayType genericArrayType) {
        Class ck;
        Type clz = genericArrayType;
        Type genericComponentType = genericArrayType.getGenericComponentType();
        String prefix = "[";
        while (genericComponentType instanceof GenericArrayType) {
            genericComponentType = ((GenericArrayType)genericComponentType).getGenericComponentType();
            prefix = prefix + prefix;
        }
        if (genericComponentType instanceof Class && (ck = (Class)genericComponentType).isPrimitive()) {
            try {
                if (ck == Boolean.TYPE) {
                    clz = Class.forName(prefix + "Z");
                } else if (ck == Character.TYPE) {
                    clz = Class.forName(prefix + "C");
                } else if (ck == Byte.TYPE) {
                    clz = Class.forName(prefix + "B");
                } else if (ck == Short.TYPE) {
                    clz = Class.forName(prefix + "S");
                } else if (ck == Integer.TYPE) {
                    clz = Class.forName(prefix + "I");
                } else if (ck == Long.TYPE) {
                    clz = Class.forName(prefix + "J");
                } else if (ck == Float.TYPE) {
                    clz = Class.forName(prefix + "F");
                } else if (ck == Double.TYPE) {
                    clz = Class.forName(prefix + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clz;
    }

    public Type getType() {
        return this.type;
    }
}

