/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.reflect;

import com.jd.laf.binding.util.Primitive;
import com.jd.laf.extension.Option;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class Constructors {
    protected static ConcurrentMap<Class<?>, ConcurrentMap<Class<?>, Option<Constructor>>> singleParameters = new ConcurrentHashMap();
    protected static ConcurrentMap<Class<?>, Option<Constructor>> defaultConstructors = new ConcurrentHashMap();
    protected static ConcurrentMap<Class<?>, List<Constructor>> constructors = new ConcurrentHashMap();

    public static List<Constructor> getConstructors(Class<?> type) {
        if (type == null || type.isInterface() || type.isArray() || type.isPrimitive()) {
            return null;
        }
        List<Constructor<Object>> options = (ArrayList)constructors.get(type);
        if (options == null) {
            options = new ArrayList();
            for (Constructor<?> constructor : type.getConstructors()) {
                options.add(constructor);
            }
            List exist = constructors.putIfAbsent(type, options);
            if (exist != null) {
                options = exist;
            }
        }
        return options;
    }

    public static Constructor getDefaultConstructor(Class<?> type) {
        Option<Constructor> option = (Option<Constructor>)defaultConstructors.get(type);
        if (option == null) {
            Option<Constructor> exist;
            int modifiers;
            List<Constructor> constructors = Constructors.getConstructors(type);
            Constructor constructor = null;
            if (constructors != null && Modifier.isPublic(modifiers = type.getModifiers()) && !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                for (Constructor c : constructors) {
                    Class<?>[] parameters;
                    if (!Modifier.isPublic(c.getModifiers()) || (parameters = c.getParameterTypes()) != null && parameters.length != 0) continue;
                    constructor = c;
                    break;
                }
            }
            if ((exist = defaultConstructors.putIfAbsent(type, option = new Option(constructor))) != null) {
                option = exist;
            }
        }
        return (Constructor)option.get();
    }

    public static Constructor getConstructor(Class<?> targetType, Class<?> parameterType) {
        Option option;
        ConcurrentMap exist;
        ConcurrentMap<Class<?>, Option> options = (ConcurrentHashMap)singleParameters.get(targetType);
        if (options == null && (exist = (ConcurrentMap)singleParameters.putIfAbsent(targetType, options = new ConcurrentHashMap())) != null) {
            options = exist;
        }
        if ((option = (Option)options.get(parameterType)) == null) {
            Option exist2;
            int modifiers;
            List<Constructor> constructors = Constructors.getConstructors(targetType);
            Constructor constructor = null;
            if (constructors != null && Modifier.isPublic(modifiers = targetType.getModifiers()) && !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                for (Constructor c : constructors) {
                    Class<?>[] parameters;
                    if (!Modifier.isPublic(c.getModifiers()) || (parameters = c.getParameterTypes()).length != 1 || !Primitive.inbox(parameters[0]).isAssignableFrom(parameterType)) continue;
                    constructor = c;
                    break;
                }
            }
            if ((exist2 = options.putIfAbsent(parameterType, option = new Option(constructor))) != null) {
                option = exist2;
            }
        }
        return (Constructor)option.get();
    }
}

