/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.reflect;

import com.jd.laf.binding.reflect.GenericMeta;
import com.jd.laf.binding.util.Collections;
import com.jd.laf.binding.util.Function;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class GenericClass {
    protected Class clazz;
    protected Map<Class, Map<String, GenericMeta>> classGeneric = new HashMap<Class, Map<String, GenericMeta>>();
    protected ConcurrentMap<Field, GenericMeta[]> fieldGeneric = new ConcurrentHashMap<Field, GenericMeta[]>();
    protected ConcurrentMap<Method, GenericMeta[][]> methodGeneric = new ConcurrentHashMap<Method, GenericMeta[][]>();

    public GenericClass(Class clazz) {
        String name;
        this.clazz = clazz;
        HashMap<String, GenericMeta> childMap = new HashMap<String, GenericMeta>(3);
        TypeVariable<Class<T>>[] variables = clazz.getTypeParameters();
        if (variables.length > 0) {
            for (TypeVariable variable : variables) {
                name = variable.toString();
                childMap.put(name, new GenericMeta(name, clazz));
            }
            this.classGeneric.put(clazz, childMap);
        }
        LinkedList queue = new LinkedList();
        queue.offer(clazz);
        while (!queue.isEmpty()) {
            clazz = (Class)queue.poll();
            Class parent = clazz.getSuperclass();
            if (parent == Object.class) continue;
            HashMap<String, GenericMeta> parentMap = new HashMap<String, GenericMeta>(3);
            variables = parent.getTypeParameters();
            Type type = clazz.getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
                for (int i = 0; i < arguments.length; ++i) {
                    Object gd;
                    Type argument = arguments[i];
                    name = variables[i].getName();
                    if (argument instanceof Class) {
                        parentMap.put(name, new GenericMeta(name, (Class)argument));
                        continue;
                    }
                    if (!(argument instanceof TypeVariable) || !((gd = ((TypeVariable)argument).getGenericDeclaration()) instanceof Class)) continue;
                    parentMap.put(name, (GenericMeta)childMap.get(name));
                }
            }
            this.classGeneric.put(parent, parentMap);
            childMap = parentMap;
            queue.offer(parent);
        }
    }

    public GenericMeta[] get(final Field field) {
        if (field == null) {
            return null;
        }
        return Collections.computeIfAbsent(this.fieldGeneric, field, new Function<Field, GenericMeta[]>(){

            @Override
            public GenericMeta[] apply(Field key) {
                return GenericClass.this.compute(field.getGenericType(), field.getType(), field.getDeclaringClass());
            }
        });
    }

    public GenericMeta[][] get(Method method) {
        if (method == null) {
            return null;
        }
        return Collections.computeIfAbsent(this.methodGeneric, method, new Function<Method, GenericMeta[][]>(){

            @Override
            public GenericMeta[][] apply(Method method) {
                GenericMeta[] infos;
                Class<?> owner = method.getDeclaringClass();
                Class<?>[] classes = method.getParameterTypes();
                Type[] types = method.getGenericParameterTypes();
                GenericMeta[][] result = new GenericMeta[classes.length][];
                LinkedList<Integer> classParameters = new LinkedList<Integer>();
                for (int i = 0; i < classes.length; ++i) {
                    infos = GenericClass.this.compute(types[i], classes[i], owner);
                    if (infos.length == 1 && classes[i] == Class.class) {
                        classParameters.add(i);
                    }
                    result[i] = infos;
                }
                for (Integer classParameter : classParameters) {
                    GenericMeta classParameterInfo = result[classParameter][0];
                    for (int i = 0; i < result.length; ++i) {
                        if (i == classParameter) continue;
                        infos = result[i];
                        for (int k = 0; k < infos.length; ++k) {
                            GenericMeta info = infos[k];
                            if (!info.getName().equals(classParameterInfo.name)) continue;
                            info.setClassParameter(classParameter);
                        }
                    }
                }
                return result;
            }
        });
    }

    protected GenericMeta[] compute(Type type, Class scopeType, Class owner) {
        LinkedList<GenericMeta> result = new LinkedList<GenericMeta>();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type[] arguments = pType.getActualTypeArguments();
            for (int i = 0; i < arguments.length; ++i) {
                Type argument = arguments[i];
                String name = argument.toString();
                if (argument instanceof Class) {
                    result.add(new GenericMeta(name, scopeType, (Class)argument));
                    continue;
                }
                if (!(argument instanceof TypeVariable)) continue;
                Object gd = ((TypeVariable)argument).getGenericDeclaration();
                if (gd instanceof Class) {
                    result.add(new GenericMeta(this.classGeneric.get(owner).get(name), scopeType));
                    continue;
                }
                if (!(gd instanceof Method)) continue;
                result.add(new GenericMeta(name));
            }
        } else if (type instanceof TypeVariable) {
            String name = type.toString();
            Object gd = ((TypeVariable)type).getGenericDeclaration();
            if (gd instanceof Class) {
                result.add(new GenericMeta(this.classGeneric.get(owner).get(name), true));
            } else if (gd instanceof Method) {
                result.add(new GenericMeta(name, true));
            }
        }
        return result.toArray(new GenericMeta[result.size()]);
    }
}

