/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.reflect;

import com.jd.laf.binding.reflect.FieldAccessorFactory;
import com.jd.laf.binding.reflect.Fields;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public interface PropertySupplier {
    public Object get(Object var1, String var2) throws Exception;

    public boolean support(Class<?> var1);

    public static class MethodSupplier
    implements PropertySupplier {
        protected Method method;

        public MethodSupplier(Method method) {
            this.method = method;
        }

        @Override
        public Object get(Object target, String name) throws Exception {
            return this.method.invoke(target, name);
        }

        @Override
        public boolean support(Class<?> clazz) {
            return true;
        }
    }

    public static class FieldSupplier
    implements PropertySupplier {
        protected FieldAccessorFactory factory;

        public FieldSupplier(FieldAccessorFactory factory) {
            this.factory = factory;
        }

        @Override
        public Object get(Object target, String name) throws Exception {
            Field field;
            if (this.factory != null && Character.isJavaIdentifierStart(name.charAt(0)) && (field = Fields.getField(target.getClass(), name)) != null) {
                return this.factory.getAccessor(field).get(target);
            }
            return null;
        }

        @Override
        public boolean support(Class<?> clazz) {
            return true;
        }
    }

    public static abstract class AbstractSupplier
    implements PropertySupplier {
        @Override
        public boolean support(Class<?> clazz) {
            return true;
        }
    }
}

