/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.reflect;

import com.jd.laf.binding.Plugin;
import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.ConversionType;
import com.jd.laf.binding.converter.Converter;
import com.jd.laf.binding.converter.Scope;
import com.jd.laf.binding.reflect.FieldAccessor;
import com.jd.laf.binding.reflect.FieldAccessorFactory;
import com.jd.laf.binding.reflect.PropertySupplier;
import com.jd.laf.binding.reflect.exception.ReflectionException;
import com.jd.laf.binding.util.Primitive;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class Reflect {
    public static Object evaluate(Object target, String expression, FieldAccessorFactory factory) throws ReflectionException {
        return Reflect.get(target, expression, new PropertySupplier.FieldSupplier(factory));
    }

    public static Object evaluate(Object target, String expression, PropertySupplier supplier) throws ReflectionException {
        Object value;
        if (target == null || expression == null) {
            return null;
        }
        String name = expression;
        if (name.length() > 3) {
            char first = name.charAt(0);
            char second = name.charAt(1);
            char end = name.charAt(name.length() - 1);
            if ((first == '$' || first == '#') && second == '{' && end == '}') {
                name = name.substring(2, name.length() - 1);
            }
        }
        if ((value = Reflect.get(target, name, supplier)) != null) {
            return value;
        }
        int pos = name.indexOf(46);
        if (pos <= 0) {
            return null;
        }
        int len = name.length();
        int start = 0;
        while (start < len) {
            value = Reflect.get(start == 0 ? target : value, name.substring(start, pos < 0 ? len : pos), supplier);
            if (value == null) {
                return null;
            }
            start = pos < 0 ? len : pos + 1;
            pos = name.indexOf(46, start);
        }
        return value;
    }

    public static Object get(Object target, String name, FieldAccessorFactory factory) throws ReflectionException {
        return Reflect.get(target, name, new PropertySupplier.FieldSupplier(factory));
    }

    public static Object get(Object target, String name, PropertySupplier supplier) throws ReflectionException {
        if (target == null || name == null || name.isEmpty()) {
            return null;
        }
        PropertySupplier getter = (PropertySupplier)Plugin.PROPERTY.select(target.getClass());
        try {
            Object result;
            Object object = result = getter == null ? null : getter.get(target, name);
            if (result == null && supplier != null) {
                result = supplier.get(target, name);
            }
            return result;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public static boolean set(Object target, Field field, Object value) throws ReflectionException {
        if (field == null || target == null || Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        FieldAccessor accessor = ((FieldAccessorFactory)Plugin.FIELD.get()).getAccessor(field);
        return Reflect.set(target, new Scope.FieldScope(target.getClass(), field, accessor), value, null);
    }

    public static boolean set(Object target, Field field, Object value, Object format, FieldAccessorFactory factory) throws ReflectionException {
        if (field == null || target == null || factory == null || Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return Reflect.set(target, new Scope.FieldScope(target.getClass(), field, factory.getAccessor(field)), value, format);
    }

    public static boolean set(Object target, Field field, Object value, FieldAccessorFactory factory) throws ReflectionException {
        if (field == null || target == null || factory == null || Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return Reflect.set(target, new Scope.FieldScope(target.getClass(), field, factory.getAccessor(field)), value, null);
    }

    public static boolean set(Object target, Field field, Object value, FieldAccessor accessor) throws ReflectionException {
        if (field == null || target == null || accessor == null || Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return Reflect.set(target, new Scope.FieldScope(target.getClass(), field, accessor), value, null);
    }

    public static boolean set(Object target, Field field, Object value, Object format, FieldAccessor accessor) throws ReflectionException {
        if (field == null || target == null || accessor == null || Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        return Reflect.set(target, new Scope.FieldScope(target.getClass(), field, accessor), value, format);
    }

    public static boolean set(Object target, Scope scope, Object value, Object format) throws ReflectionException {
        if (scope == null || target == null) {
            return false;
        }
        try {
            Object obj;
            Class type = scope.getType();
            if (value == null) {
                if (type.isPrimitive()) {
                    return false;
                }
                scope.update(target, null);
                return true;
            }
            if (type == Object.class) {
                Class genericType = scope.getGenericType();
                type = genericType != null ? genericType : type;
            }
            Class<?> inboxTargetType = Primitive.inbox(type);
            Class<?> inboxSourceType = Primitive.inbox(value.getClass());
            Converter operation = (Converter)Plugin.CONVERTER.select((Object)new ConversionType(inboxSourceType, inboxTargetType, scope));
            if (operation != null && (obj = operation.execute(new Conversion(inboxSourceType, inboxTargetType, value, format, scope))) != null) {
                scope.update(target, obj);
                return true;
            }
            return false;
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public static boolean support(Class<?> source, Class<?> target) {
        if (source == null || target == null) {
            return false;
        }
        return Plugin.CONVERTER.select((Object)new ConversionType(Primitive.inbox(source), Primitive.inbox(target))) != null;
    }

    public static boolean support(Class<?> source, Class<?> target, Scope scope) {
        if (source == null || target == null) {
            return false;
        }
        return Plugin.CONVERTER.select((Object)new ConversionType(Primitive.inbox(source), Primitive.inbox(target), scope)) != null;
    }
}

