/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.reflect;

import com.jd.laf.binding.reflect.FieldAccessor;
import com.jd.laf.binding.reflect.exception.ReflectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectAccessor
implements FieldAccessor {
    private Field field;
    private Method getter;
    private Method setter;

    public ReflectAccessor(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("getField can not be null.");
        }
        this.field = field;
        Class<?> clazz = field.getDeclaringClass();
        if (clazz != null) {
            Method[] methods;
            String name = field.getName();
            char[] data = name.toCharArray();
            data[0] = Character.toUpperCase(data[0]);
            name = new String(data);
            String getName = "get" + name;
            String getBoolName = field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? "is" + name : null;
            String setName = "set" + name;
            int count = 0;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Class<?>[] types;
                if (!Modifier.isPublic(method.getModifiers())) continue;
                name = method.getName();
                if (name.equals(getName) || getBoolName != null && name.equals(getBoolName)) {
                    types = method.getParameterTypes();
                    if (types == null || types.length == 0) {
                        this.getter = method;
                        ++count;
                    }
                } else if (name.equals(setName) && (types = method.getParameterTypes()) != null && types.length == 1 && types[0] == field.getType()) {
                    this.setter = method;
                    ++count;
                }
                if (count == 2) break;
            }
        }
    }

    @Override
    public Object get(Object target) throws ReflectionException {
        if (target == null) {
            return null;
        }
        if (this.getter != null) {
            return this.getter.invoke(target, new Object[0]);
        }
        if (this.field.isAccessible()) {
            return this.field.get(target);
        }
        this.field.setAccessible(true);
        try {
            Object object = this.field.get(target);
            this.field.setAccessible(false);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.field.setAccessible(false);
                throw throwable;
            }
            catch (Exception e) {
                throw new ReflectionException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void set(Object target, Object value) throws ReflectionException {
        try {
            if (target == null) {
                return;
            }
            if (this.setter != null) {
                this.setter.invoke(target, value);
            } else if (this.field.isAccessible()) {
                this.field.set(target, value);
            } else {
                this.field.setAccessible(true);
                this.field.set(target, value);
            }
        }
        catch (Exception e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }
}

