/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.util;

import com.jd.laf.binding.util.Function;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;

public abstract class Collections {
    public static Collection create(Class<?> targetType, int size) throws Exception {
        if (targetType == null) {
            return null;
        }
        if (targetType.equals(List.class)) {
            return new ArrayList(size);
        }
        if (targetType.equals(Set.class)) {
            return new HashSet(size);
        }
        if (targetType.equals(SortedSet.class)) {
            return new TreeSet();
        }
        if (targetType.isInterface()) {
            return null;
        }
        if (Modifier.isAbstract(targetType.getModifiers())) {
            return null;
        }
        return (Collection)targetType.newInstance();
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Function<K, V> function) {
        V exists;
        Object result = map.get(key);
        if (result == null && (exists = map.putIfAbsent(key, result = function.apply(key))) != null) {
            result = exists;
        }
        return result;
    }
}

