/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class Strings {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static List<String> split(String value, String delimiter) {
        LinkedList<String> result = new LinkedList<String>();
        if (delimiter == null || delimiter.isEmpty()) {
            return Strings.split(value, ',');
        }
        if (delimiter.length() == 1) {
            return Strings.split(value, delimiter.charAt(0));
        }
        int length = value.length();
        int maxPos = delimiter.length() - 1;
        int start = 0;
        int pos = 0;
        int end = 0;
        for (int i = 0; i < length; ++i) {
            if (value.charAt(i) == delimiter.charAt(pos)) {
                if (pos++ != maxPos) continue;
                if (end > start) {
                    result.add(value.substring(start, end + 1));
                }
                pos = 0;
                start = i + 1;
                continue;
            }
            end = i;
        }
        if (start < length) {
            result.add(value.substring(start, length));
        }
        return result;
    }

    public static List<String> split(String value, char delimiter) {
        LinkedList<String> result = new LinkedList<String>();
        int len = value.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (value.charAt(i) != delimiter) continue;
            if (i > start) {
                result.add(value.substring(start, i));
            }
            start = i + 1;
        }
        if (start < len) {
            result.add(value.substring(start, len));
        }
        return result;
    }

    protected static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static StringBuilder store(StringBuilder builder, String value, boolean escapeSpace, boolean escapeUnicode) {
        if (value == null) {
            return builder;
        }
        int len = value.length();
        block8: for (int x = 0; x < len; ++x) {
            char aChar = value.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    builder.append('\\');
                    builder.append('\\');
                    continue;
                }
                builder.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        builder.append('\\');
                    }
                    builder.append(' ');
                    continue block8;
                }
                case '\t': {
                    builder.append('\\');
                    builder.append('t');
                    continue block8;
                }
                case '\n': {
                    builder.append('\\');
                    builder.append('n');
                    continue block8;
                }
                case '\r': {
                    builder.append('\\');
                    builder.append('r');
                    continue block8;
                }
                case '\f': {
                    builder.append('\\');
                    builder.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    builder.append('\\');
                    builder.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        builder.append('\\');
                        builder.append('u');
                        builder.append(Strings.toHex(aChar >> 12 & 0xF));
                        builder.append(Strings.toHex(aChar >> 8 & 0xF));
                        builder.append(Strings.toHex(aChar >> 4 & 0xF));
                        builder.append(Strings.toHex(aChar & 0xF));
                        continue block8;
                    }
                    builder.append(aChar);
                }
            }
        }
        return builder;
    }

    public static StringBuilder store(StringBuilder builder, Properties properties) {
        if (builder != null && properties != null) {
            int count = 0;
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (count++ > 0) {
                    builder.append(LINE_SEPARATOR);
                }
                Strings.store(builder, (String)entry.getKey(), true, false).append('=');
                Strings.store(builder, (String)entry.getValue(), false, false);
            }
        }
        return builder;
    }

    public static String toString(Properties properties) {
        if (properties == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(8192);
        Strings.store(builder, properties);
        return builder.toString();
    }
}

