/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joyqueue.helper.PortHelper;

public class Broker
implements Serializable {
    public static final String DEFAULT_RETRY_TYPE = "RemoteRetry";
    public static final String PERMISSION_FULL = "FULL";
    public static final String PERMISSION_READ = "READ";
    public static final String PERMISSION_WRITE = "WRITE";
    public static final String PERMISSION_NONE = "NONE";
    public static final String DEFAULT_PERMISSION = "FULL";
    protected int id;
    @NotNull(message="The ip can not be null")
    protected @NotNull(message="The ip can not be null") String ip;
    @NotNull(message="The port can not be null")
    @Min(value=100L, message="Please enter 100 to 65535")
    @Max(value=65535L, message="Please enter 100 to 65535")
    protected @NotNull(message="The port can not be null") @Min(value=100L, message="Please enter 100 to 65535") @Max(value=65535L, message="Please enter 100 to 65535") int port;
    protected String dataCenter;
    protected String retryType = "RemoteRetry";
    protected PermissionEnum permission = PermissionEnum.FULL;

    public Integer getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Transient
    public String getAddress() {
        return this.ip + ":" + this.port;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    public String getRetryType() {
        return this.retryType;
    }

    public void setRetryType(String retryType) {
        this.retryType = retryType;
    }

    public PermissionEnum getPermission() {
        return this.permission;
    }

    public void setPermission(PermissionEnum permission) {
        this.permission = permission;
    }

    @Transient
    public int getBackEndPort() {
        return PortHelper.getBackendPort(this.port);
    }

    @Transient
    public int getMonitorPort() {
        return PortHelper.getMonitorPort(this.port);
    }

    @Transient
    public int getNameServerManagerPort() {
        return PortHelper.getNameServerManagerPort(this.port);
    }

    @Transient
    public int getNameServerPort() {
        return PortHelper.getNameServerPort(this.port);
    }

    @Transient
    public int getMessengerPort() {
        return PortHelper.getMessengerPort(this.port);
    }

    @Transient
    public int getJournalkeeperPort() {
        return PortHelper.getJournalkeeperPort(this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Broker)) {
            return false;
        }
        Broker broker = (Broker)o;
        return this.id == broker.id && this.port == broker.port && Objects.equals(this.ip, broker.ip) && Objects.equals(this.dataCenter, broker.dataCenter) && Objects.equals(this.retryType, broker.retryType) && this.permission == broker.permission;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.ip, this.port, this.dataCenter, this.retryType, this.permission});
    }

    public String toString() {
        return "Broker{id=" + this.id + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", dataCenter='" + this.dataCenter + '\'' + ", retryType=" + this.retryType + ", permission=" + (Object)((Object)this.permission) + '}';
    }

    public static enum PermissionEnum {
        FULL(0, "FULL"),
        READ(1, "READ"),
        WRITE(2, "WRITE"),
        NONE(3, "NONE");

        private int value;
        private String name;

        private PermissionEnum(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public static PermissionEnum value(String permission) {
            for (PermissionEnum permissionEnum : PermissionEnum.values()) {
                if (!permissionEnum.name.equals(permission)) continue;
                return permissionEnum;
            }
            return FULL;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

