/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.TopicType;
import org.joyqueue.toolkit.retry.RetryPolicy;

public class Consumer
extends Subscription {
    protected ClientType clientType;
    protected TopicType topicType = TopicType.TOPIC;
    protected RetryPolicy retryPolicy;
    protected ConsumerPolicy consumerPolicy;
    protected ConsumerLimitPolicy limitPolicy;

    public Consumer() {
        this.setType(Subscription.Type.CONSUMPTION);
    }

    public String getId() {
        return new StringBuilder(30).append(this.topic.getFullName()).append(".").append(this.app).toString();
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public TopicType getTopicType() {
        return this.topicType;
    }

    public void setTopicType(TopicType topicType) {
        this.topicType = topicType;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public ConsumerPolicy getConsumerPolicy() {
        return this.consumerPolicy;
    }

    public void setConsumerPolicy(ConsumerPolicy consumerPolicy) {
        this.consumerPolicy = consumerPolicy;
    }

    public void setLimitPolicy(ConsumerLimitPolicy limitPolicy) {
        this.limitPolicy = limitPolicy;
    }

    public ConsumerLimitPolicy getLimitPolicy() {
        return this.limitPolicy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Consumer)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Consumer consumer = (Consumer)o;
        return this.clientType == consumer.clientType && this.topicType == consumer.topicType && Objects.equals(this.retryPolicy, consumer.retryPolicy) && Objects.equals(this.consumerPolicy, consumer.consumerPolicy) && Objects.equals(this.limitPolicy, consumer.limitPolicy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.clientType, this.topicType, this.retryPolicy, this.consumerPolicy, this.limitPolicy});
    }

    public static class ConsumerPolicy
    implements Serializable {
        private Boolean nearby;
        private Boolean paused;
        private Boolean archive;
        private Boolean retry;
        @Deprecated
        private Boolean seq;
        private Integer ackTimeout = 12000;
        private Short batchSize;
        private Integer concurrent;
        private Integer delay = 0;
        private Set<String> blackList;
        private Integer errTimes;
        private Integer maxPartitionNum;
        private Integer readRetryProbability;
        private Map<String, String> filters;

        public ConsumerPolicy() {
        }

        public ConsumerPolicy(Boolean nearby, Boolean paused, Boolean archive, Boolean retry, Boolean seq, Integer ackTimeout, Short batchSize, Integer concurrent, Integer delay, Set<String> blackList, Integer errTimes, Integer maxPartitionNum, Integer readRetryProbability, Map<String, String> filters) {
            this.nearby = nearby;
            this.paused = paused;
            this.archive = archive;
            this.retry = retry;
            this.seq = seq;
            this.ackTimeout = ackTimeout;
            this.batchSize = batchSize;
            this.concurrent = concurrent;
            this.delay = delay;
            this.blackList = blackList;
            this.errTimes = errTimes;
            this.maxPartitionNum = maxPartitionNum;
            this.readRetryProbability = readRetryProbability;
            this.filters = filters;
        }

        public void setAckTimeout(Integer ackTimeout) {
            this.ackTimeout = ackTimeout;
        }

        public void setBatchSize(Short batchSize) {
            this.batchSize = batchSize;
        }

        public Boolean getNearby() {
            return this.nearby;
        }

        public Boolean getPaused() {
            return this.paused;
        }

        public Boolean getArchive() {
            return this.archive;
        }

        public Boolean getRetry() {
            return this.retry;
        }

        public Boolean getSeq() {
            return this.seq;
        }

        public Integer getAckTimeout() {
            return this.ackTimeout;
        }

        public Short getBatchSize() {
            return this.batchSize;
        }

        public Boolean isConcurrent() {
            return this.concurrent > 1;
        }

        public Integer getConcurrent() {
            return this.concurrent;
        }

        public Integer getConcurrentPrefetchSize() {
            return this.concurrent * this.batchSize;
        }

        public Integer getDelay() {
            return this.delay;
        }

        public Set<String> getBlackList() {
            return this.blackList;
        }

        public Integer getErrTimes() {
            return this.errTimes;
        }

        public Integer getMaxPartitionNum() {
            return this.maxPartitionNum;
        }

        public void setNearby(Boolean nearby) {
            this.nearby = nearby;
        }

        public void setPaused(Boolean paused) {
            this.paused = paused;
        }

        public void setArchive(Boolean archive) {
            this.archive = archive;
        }

        public void setRetry(Boolean retry) {
            this.retry = retry;
        }

        public void setSeq(Boolean seq) {
            this.seq = seq;
        }

        public void setConcurrent(Integer concurrent) {
            this.concurrent = concurrent;
        }

        public void setMaxPartitionNum(Integer maxPartitionNum) {
            this.maxPartitionNum = maxPartitionNum;
        }

        public void setReadRetryProbability(Integer readRetryProbability) {
            this.readRetryProbability = readRetryProbability;
        }

        public void setDelay(Integer delay) {
            this.delay = delay;
        }

        public void setErrTimes(Integer errTimes) {
            this.errTimes = errTimes;
        }

        public void setBlackList(Set<String> blackList) {
            this.blackList = blackList;
        }

        public Integer getReadRetryProbability() {
            return this.readRetryProbability;
        }

        public void setFilters(Map<String, String> filters) {
            this.filters = filters;
        }

        public Map<String, String> getFilters() {
            return this.filters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumerPolicy that = (ConsumerPolicy)o;
            return Objects.equals(this.nearby, that.nearby) && Objects.equals(this.paused, that.paused) && Objects.equals(this.archive, that.archive) && Objects.equals(this.retry, that.retry) && Objects.equals(this.seq, that.seq) && Objects.equals(this.ackTimeout, that.ackTimeout) && Objects.equals(this.batchSize, that.batchSize) && Objects.equals(this.concurrent, that.concurrent) && Objects.equals(this.delay, that.delay) && Objects.equals(this.blackList, that.blackList) && Objects.equals(this.errTimes, that.errTimes) && Objects.equals(this.maxPartitionNum, that.maxPartitionNum) && Objects.equals(this.readRetryProbability, that.readRetryProbability) && Objects.equals(this.filters, that.filters);
        }

        public int hashCode() {
            return Objects.hash(this.nearby, this.paused, this.archive, this.retry, this.seq, this.ackTimeout, this.batchSize, this.concurrent, this.delay, this.blackList, this.errTimes, this.maxPartitionNum, this.readRetryProbability, this.filters);
        }

        public static class Builder {
            private Boolean nearby = false;
            private Boolean paused = false;
            private Boolean archive = false;
            private Boolean retry = true;
            private Boolean seq = false;
            private Integer ackTimeout = 300000;
            private Short batchSize = 10;
            private Integer concurrent = 1;
            private Integer delay = 0;
            private Integer errTimes = 3;
            private Integer maxPartitionNum = Integer.MAX_VALUE;
            private Set<String> blackList;
            private Integer retryReadProbability = 20;
            private Map<String, String> filters = new HashMap<String, String>();

            public static Builder build() {
                return new Builder();
            }

            public Builder nearby(Boolean nearby) {
                this.nearby = nearby;
                return this;
            }

            public Builder paused(Boolean paused) {
                this.paused = paused;
                return this;
            }

            public Builder archive(Boolean archive) {
                this.archive = archive;
                return this;
            }

            public Builder retry(Boolean retry) {
                this.retry = retry;
                return this;
            }

            public Builder seq(Boolean seq) {
                this.seq = seq;
                return this;
            }

            public Builder ackTimeout(Integer ackTimeout) {
                this.ackTimeout = ackTimeout;
                return this;
            }

            public Builder batchSize(Short batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder concurrent(Integer concurrent) {
                this.concurrent = concurrent;
                return this;
            }

            public Builder delay(Integer delay) {
                this.delay = delay;
                return this;
            }

            public Builder errTimes(Integer errTimes) {
                this.errTimes = errTimes;
                return this;
            }

            public Builder maxPartitionNum(Integer maxPartitionNum) {
                this.maxPartitionNum = maxPartitionNum;
                return this;
            }

            public Builder blackList(String blackList) {
                if (null != blackList && !"".equals(blackList.trim())) {
                    this.blackList = new HashSet<String>(Arrays.asList(blackList.trim().split(",")));
                }
                return this;
            }

            public Builder retryReadProbability(Integer retryReadProbability) {
                this.retryReadProbability = retryReadProbability;
                return this;
            }

            public Builder filters(String filtersStr) {
                if (filtersStr != null && !"".equals(filtersStr.trim())) {
                    String[] filterArray = filtersStr.split(",");
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String filter : filterArray) {
                        map.put(filter.split(":")[0], filter.split(":")[1]);
                    }
                    this.filters = map;
                }
                return this;
            }

            public Builder filters(Map<String, String> filters) {
                this.filters = filters;
                return this;
            }

            public ConsumerPolicy create() {
                return new ConsumerPolicy(this.nearby, this.paused, this.archive, this.retry, this.seq, this.ackTimeout, this.batchSize, this.concurrent, this.delay, this.blackList, this.errTimes, this.maxPartitionNum, this.retryReadProbability, this.filters);
            }
        }
    }

    public static class ConsumerLimitPolicy
    implements Serializable {
        private Integer tps;
        private Integer traffic;

        public ConsumerLimitPolicy() {
        }

        public ConsumerLimitPolicy(Integer tps, Integer traffic) {
            this.tps = tps;
            this.traffic = traffic;
        }

        public void setTps(Integer tps) {
            this.tps = tps;
        }

        public Integer getTps() {
            return this.tps;
        }

        public void setTraffic(Integer traffic) {
            this.traffic = traffic;
        }

        public Integer getTraffic() {
            return this.traffic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumerLimitPolicy that = (ConsumerLimitPolicy)o;
            return Objects.equals(this.tps, that.tps) && Objects.equals(this.traffic, that.traffic);
        }

        public int hashCode() {
            return Objects.hash(this.tps, this.traffic);
        }
    }
}

