/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Set;
import org.joyqueue.domain.Broker;

public class Partition
implements Serializable {
    public static final short RETRY_PARTITION_ID = Short.MAX_VALUE;
    public static final short MAX_PARTITION_ID = 32766;
    public static final short MIN_PARTITION_ID = 0;
    private short partitionId;
    private Broker leader;
    private Set<Broker> replicas;
    private Set<Broker> isrs;

    public Partition(short partitionId) {
        this(partitionId, null, null, null);
    }

    public Partition(short partitionId, Broker leader, Set<Broker> replicas, Set<Broker> isrs) {
        Preconditions.checkArgument((partitionId >= 0 && partitionId <= 32766 ? 1 : 0) != 0, (Object)"partition id must in [0,32767]");
        this.partitionId = partitionId;
        this.leader = leader;
        this.replicas = replicas;
        this.isrs = isrs;
    }

    public short getPartitionId() {
        return this.partitionId;
    }

    public Broker getLeader() {
        return this.leader;
    }

    public Set<Broker> getReplicas() {
        return this.replicas;
    }

    public Set<Broker> getIsrs() {
        return this.isrs;
    }
}

