/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.TopicName;

public class PartitionGroup
implements Serializable {
    protected TopicName topic;
    protected int group;
    protected Set<Short> partitions;
    protected Integer leader = -1;
    protected Integer recLeader = -1;
    protected Integer term = 0;
    protected Set<Integer> replicas;
    protected Set<Integer> isrs;
    protected Set<Integer> learners;
    protected Map<Integer, Broker> brokers;
    protected List<Integer> outSyncReplicas = new ArrayList<Integer>();
    protected ElectType electType = ElectType.fix;

    public String getId() {
        return new StringBuilder(30).append(this.topic.getFullName()).append(".").append(this.group).toString();
    }

    public Broker getLeaderBroker() {
        if (this.leader == null || this.leader.equals(-1)) {
            return null;
        }
        return null == this.brokers ? null : this.brokers.get(this.leader);
    }

    public TopicName getTopic() {
        return this.topic;
    }

    public void setTopic(TopicName topic) {
        this.topic = topic;
    }

    public Set<Integer> getIsrs() {
        if (null == this.isrs) {
            return Collections.EMPTY_SET;
        }
        return this.isrs;
    }

    public void setIsrs(Set<Integer> isrs) {
        this.isrs = isrs;
    }

    public Integer getTerm() {
        return this.term;
    }

    public void setTerm(Integer term) {
        this.term = term;
    }

    public Integer getRecLeader() {
        return this.recLeader;
    }

    public void setRecLeader(Integer recLeader) {
        this.recLeader = recLeader;
    }

    public Integer getLeader() {
        return this.leader;
    }

    public void setLeader(Integer leader) {
        this.leader = leader;
    }

    public Set<Short> getPartitions() {
        if (null == this.partitions) {
            return Collections.EMPTY_SET;
        }
        return this.partitions;
    }

    public void setPartitions(Set<Short> partitions) {
        this.partitions = partitions;
    }

    public Set<Integer> getReplicas() {
        if (null == this.replicas) {
            return Collections.EMPTY_SET;
        }
        return this.replicas;
    }

    public void setReplicas(Set<Integer> replicas) {
        this.replicas = replicas;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public Map<Integer, Broker> getBrokers() {
        return this.brokers;
    }

    public ElectType getElectType() {
        return this.electType;
    }

    public void setElectType(ElectType electType) {
        this.electType = electType;
    }

    public void setBrokers(Map<Integer, Broker> brokers) {
        this.brokers = brokers;
    }

    public Set<Integer> getLearners() {
        if (null == this.learners) {
            return Collections.EMPTY_SET;
        }
        return this.learners;
    }

    public void setLearners(Set<Integer> learners) {
        this.learners = learners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PartitionGroup)) {
            return false;
        }
        PartitionGroup that = (PartitionGroup)o;
        return this.group == that.group && Objects.equals(this.topic, that.topic) && Objects.equals(this.partitions, that.partitions) && Objects.equals(this.leader, that.leader) && Objects.equals(this.recLeader, that.recLeader) && Objects.equals(this.term, that.term) && Objects.equals(this.replicas, that.replicas) && Objects.equals(this.isrs, that.isrs) && Objects.equals(this.learners, that.learners) && this.electType == that.electType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topic, this.group, this.partitions, this.leader, this.recLeader, this.term, this.replicas, this.isrs, this.learners, this.electType});
    }

    public PartitionGroup clone() {
        PartitionGroup partitionGroup = new PartitionGroup();
        partitionGroup.setTopic(this.topic);
        partitionGroup.setLeader(this.leader);
        partitionGroup.setRecLeader(this.recLeader);
        partitionGroup.setTerm(this.term);
        partitionGroup.setGroup(this.group);
        partitionGroup.setBrokers((Map<Integer, Broker>)(null != this.brokers ? new HashMap<Integer, Broker>(this.brokers) : new HashMap()));
        partitionGroup.setElectType(this.getElectType());
        if (null != this.isrs) {
            partitionGroup.setIsrs(new TreeSet<Integer>(this.isrs));
        }
        if (null != this.learners) {
            partitionGroup.setLearners(new TreeSet<Integer>(this.learners));
        }
        if (null != this.partitions) {
            partitionGroup.setPartitions(new TreeSet<Short>(this.partitions));
        }
        if (null != this.replicas) {
            partitionGroup.setReplicas(new TreeSet<Integer>(this.replicas));
        }
        return partitionGroup;
    }

    public List<Integer> getOutSyncReplicas() {
        return this.outSyncReplicas;
    }

    public void setOutSyncReplicas(List<Integer> outSyncReplicas) {
        this.outSyncReplicas = outSyncReplicas;
    }

    public String toString() {
        return "PartitionGroup{topic='" + this.topic + '\'' + ", leader=" + this.leader + ", isrs=" + this.isrs + ", learners=" + this.learners + ", term=" + this.term + ", group=" + this.group + ", partitions=" + this.partitions + ", replicas=" + this.replicas + ", brokers=" + this.brokers + ", electType=" + (Object)((Object)this.electType) + '}';
    }

    public static enum ElectType {
        fix(1),
        raft(0);

        private int type;

        private ElectType(int type) {
            this.type = type;
        }

        public static ElectType valueOf(int type) {
            switch (type) {
                case 0: {
                    return raft;
                }
                case 1: {
                    return fix;
                }
            }
            return raft;
        }

        public static ElectType value(String typeName) {
            if (fix.name().equals(typeName.toLowerCase())) {
                return fix;
            }
            return raft;
        }

        public int type() {
            return this.type;
        }
    }
}

